/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.integtestsupport;

import com.google.common.base.Throwables;
import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.core.integtestsupport.ExceptionRecognizerTranslate;
import org.apache.isis.core.integtestsupport.IsisSystemForTest;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.specsupport.scenarios.ScenarioExecution;
import org.apache.isis.core.unittestsupport.jmocking.JUnitRuleMockery2;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class IntegrationTestAbstract {
    @Rule
    public IsisTransactionRule isisTransactionRule = new IsisTransactionRule();
    @Rule
    public JUnitRuleMockery2 context = JUnitRuleMockery2.createFor((JUnitRuleMockery2.Mode)JUnitRuleMockery2.Mode.INTERFACES_AND_CLASSES);
    @Rule
    public ExpectedException expectedExceptions = ExpectedException.none();
    @Rule
    public ExceptionRecognizerTranslate exceptionRecognizerTranslations = ExceptionRecognizerTranslate.create();

    @Deprecated
    protected static ScenarioExecution scenarioExecution() {
        return ScenarioExecution.current();
    }

    @Deprecated
    protected void nextTransaction() {
        IntegrationTestAbstract.scenarioExecution().endTran(true);
        IntegrationTestAbstract.scenarioExecution().beginTran();
    }

    @Deprecated
    protected void nextRequest() {
        this.nextTransaction();
    }

    @Deprecated
    protected void nextSession() {
        IntegrationTestAbstract.scenarioExecution().endTran(true);
        IntegrationTestAbstract.scenarioExecution().closeSession();
        IntegrationTestAbstract.scenarioExecution().openSession();
        IntegrationTestAbstract.scenarioExecution().beginTran();
    }

    protected FixtureClock getFixtureClock() {
        return (FixtureClock)FixtureClock.getInstance();
    }

    @Deprecated
    public Object getVar(String type, String id) {
        return IntegrationTestAbstract.scenarioExecution().getVar(type, id);
    }

    @Deprecated
    public <X> X getVar(String type, String id, Class<X> cls) {
        return (X)IntegrationTestAbstract.scenarioExecution().getVar(type, id, cls);
    }

    @Deprecated
    public void putVar(String type, String id, Object value) {
        IntegrationTestAbstract.scenarioExecution().putVar(type, id, value);
    }

    @Deprecated
    public void removeVar(String type, String id) {
        IntegrationTestAbstract.scenarioExecution().removeVar(type, id);
    }

    @Deprecated
    protected <T> T service(Class<T> cls) {
        return (T)IntegrationTestAbstract.scenarioExecution().service(cls);
    }

    @Deprecated
    protected DomainObjectContainer container() {
        return IntegrationTestAbstract.scenarioExecution().container();
    }

    @Deprecated
    protected WrapperFactory wrapperFactory() {
        return IntegrationTestAbstract.scenarioExecution().wrapperFactory();
    }

    protected <T> T wrap(T obj) {
        return (T)IntegrationTestAbstract.scenarioExecution().wrapperFactory().wrap(obj);
    }

    protected <T> T unwrap(T obj) {
        return (T)IntegrationTestAbstract.scenarioExecution().wrapperFactory().unwrap(obj);
    }

    protected <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.container().mixin(mixinClass, mixedIn);
    }

    @Deprecated
    protected static void runScript(FixtureScript ... fixtureScripts) {
        IntegrationTestAbstract.scenarioExecution().install((InstallableFixture[])fixtureScripts);
    }

    private static class IsisTransactionRule
    implements MethodRule {
        private IsisTransactionRule() {
        }

        public Statement apply(final Statement base, FrameworkMethod method, final Object target) {
            final IsisSystemForTest isft = IsisSystemForTest.get();
            return new Statement(){

                public void evaluate() throws Throwable {
                    isft.getContainer().injectServicesInto(target);
                    isft.beginTran();
                    try {
                        base.evaluate();
                        isft.endTran();
                        isft.nextSession();
                    }
                    catch (Throwable e) {
                        this.endTransactionTilDone();
                        isft.nextSession();
                        List causalChain = Throwables.getCausalChain((Throwable)e);
                        for (Throwable cause : causalChain) {
                            if (!(cause instanceof RecoverableException) && !(cause instanceof NonRecoverableException)) continue;
                            throw cause;
                        }
                        throw e;
                    }
                }

                protected void endTransactionTilDone() {
                    IsisTransactionManager tranMgr = isft.getIsisSessionFactory().getCurrentSession().getPersistenceSession().getTransactionManager();
                    int count = 0;
                    while (tranMgr.getTransactionLevel() > 0 && count++ < 10) {
                        try {
                            tranMgr.endTransaction();
                        }
                        catch (Exception exception) {}
                    }
                }
            };
        }
    }
}

