/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.integtestsupport;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.integtestsupport.IsisComponentProviderDefault;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerDelegate;
import org.apache.isis.core.runtime.logging.IsisLoggingConfigurer;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.isis.core.security.authentication.AuthenticationRequestNameOnly;
import org.apache.isis.core.specsupport.scenarios.DomainServiceProvider;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IsisSystemForTest
implements TestRule,
DomainServiceProvider {
    private static ThreadLocal<IsisSystemForTest> ISFT = new ThreadLocal();
    private final AppManifest appManifestIfAny;
    private final IsisConfiguration configurationOverride;
    private final AuthenticationRequest authenticationRequestIfAny;
    private AuthenticationSession authenticationSession;
    private Level level = Level.INFO;
    private IsisComponentProvider componentProvider;
    private IsisSessionFactory isisSessionFactory;
    private List<Listener> listeners;

    public static IsisSystemForTest getElseNull() {
        return ISFT.get();
    }

    public static IsisSystemForTest get() {
        IsisSystemForTest isft = ISFT.get();
        if (isft == null) {
            throw new IllegalStateException("No IsisSystemForTest available on thread; call #set(IsisSystemForTest) first");
        }
        return isft;
    }

    public static void set(IsisSystemForTest isft) {
        ISFT.set(isft);
    }

    public static Builder builder() {
        return new Builder();
    }

    private IsisSystemForTest(AppManifest appManifestIfAny, IsisConfiguration configurationOverride, AuthenticationRequest authenticationRequestIfAny, List<Listener> listeners) {
        this.appManifestIfAny = appManifestIfAny;
        this.configurationOverride = configurationOverride;
        this.authenticationRequestIfAny = authenticationRequestIfAny;
        this.listeners = listeners;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public IsisSystemForTest setUpSystem() throws RuntimeException {
        try {
            this.initIfRequiredThenOpenSession(FireListeners.FIRE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private void initIfRequiredThenOpenSession(FireListeners fireListeners) throws Exception {
        boolean firstTime;
        MetaModelInvalidException mmie = IsisContext.getMetaModelInvalidExceptionIfAny();
        if (mmie != null) {
            Set validationErrors = mmie.getValidationErrors();
            String validationMsg = Joiner.on((String)"\n").join((Iterable)validationErrors);
            Assert.fail((String)validationMsg);
            return;
        }
        boolean bl = firstTime = this.isisSessionFactory == null;
        if (fireListeners.shouldFire()) {
            this.fireInitAndPreOpenSession(firstTime);
        }
        if (firstTime) {
            IsisLoggingConfigurer isisLoggingConfigurer = new IsisLoggingConfigurer(this.getLevel());
            isisLoggingConfigurer.configureLogging(".", new String[0]);
            this.componentProvider = new IsisComponentProviderDefault(this.appManifestIfAny, this.configurationOverride);
            IsisSessionFactoryBuilder isisSessionFactoryBuilder = new IsisSessionFactoryBuilder(this.componentProvider, DeploymentCategory.PRODUCTION);
            FixtureClock.initialize();
            this.isisSessionFactory = isisSessionFactoryBuilder.buildSessionFactory();
            this.closeSession();
            MetaModelInvalidException ex = IsisContext.getMetaModelInvalidExceptionIfAny();
            if (ex != null) {
                IsisContext.testReset();
                Set validationErrors = ex.getValidationErrors();
                StringBuilder buf = new StringBuilder();
                for (String validationError : validationErrors) {
                    buf.append(validationError).append("\n");
                }
                Assert.fail((String)("Metamodel is invalid: \n" + buf.toString()));
            }
        }
        AuthenticationManager authenticationManager = this.isisSessionFactory.getAuthenticationManager();
        this.authenticationSession = authenticationManager.authenticate(this.authenticationRequestIfAny);
        this.openSession();
        if (fireListeners.shouldFire()) {
            this.firePostOpenSession(firstTime);
        }
    }

    public DomainObjectContainer getContainer() {
        return this.getService(DomainObjectContainer.class);
    }

    public IsisSessionFactory getIsisSessionFactory() {
        return this.isisSessionFactory;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    private void closeSession(FireListeners fireListeners) throws Exception {
        if (fireListeners.shouldFire()) {
            this.firePreCloseSession();
        }
        if (this.isisSessionFactory.inSession()) {
            this.isisSessionFactory.closeSession();
        }
        if (fireListeners.shouldFire()) {
            this.firePostCloseSession();
        }
    }

    public void nextSession() throws Exception {
        this.firePreNextSession();
        this.closeSession();
        this.openSession();
        this.firePostNextSession();
    }

    public void openSession() throws Exception {
        this.openSession(this.authenticationSession);
    }

    public void openSession(AuthenticationSession authenticationSession) throws Exception {
        this.isisSessionFactory.openSession(authenticationSession);
    }

    public void closeSession() throws Exception {
        this.closeSession(FireListeners.FIRE);
    }

    private void fireInitAndPreOpenSession(boolean firstTime) throws Exception {
        if (firstTime) {
            for (Listener listener : this.listeners) {
                listener.init((IsisConfiguration)this.componentProvider.getConfiguration());
            }
        }
        for (Listener listener : this.listeners) {
            listener.preOpenSession(firstTime);
        }
    }

    private void firePostOpenSession(boolean firstTime) throws Exception {
        for (Listener listener : this.listeners) {
            listener.postOpenSession(firstTime);
        }
    }

    private void firePreCloseSession() throws Exception {
        for (Listener listener : this.listeners) {
            listener.preCloseSession();
        }
    }

    private void firePostCloseSession() throws Exception {
        for (Listener listener : this.listeners) {
            listener.postCloseSession();
        }
    }

    private void firePreNextSession() throws Exception {
        for (Listener listener : this.listeners) {
            listener.preNextSession();
        }
    }

    private void firePostNextSession() throws Exception {
        for (Listener listener : this.listeners) {
            listener.postNextSession();
        }
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                IsisSystemForTest.this.setUpSystem();
                try {
                    base.evaluate();
                    IsisSystemForTest.this.closeSession();
                }
                catch (Throwable ex) {
                    try {
                        IsisSystemForTest.this.closeSession();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ex;
                }
            }
        };
    }

    @Deprecated
    public void beginTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            this.startTransactionForUser(transactionManager);
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: 
            case ABORTED: {
                this.startTransactionForUser(transactionManager);
                break;
            }
            case IN_PROGRESS: {
                break;
            }
            case MUST_ABORT: {
                Assert.fail((String)("Transaction is in state of '" + state + "'"));
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    private void startTransactionForUser(IsisTransactionManager transactionManager) {
        transactionManager.startTransaction();
        CommandContext commandContext = this.getService(CommandContext.class);
        Command command = commandContext.getCommand();
        command.setExecutor(Command.Executor.USER);
    }

    @Deprecated
    public void endTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            Assert.fail((String)"No transaction exists");
            return;
        }
        transactionManager.endTransaction();
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: {
                break;
            }
            case ABORTED: {
                break;
            }
            case IN_PROGRESS: {
                Assert.fail((String)("Transaction is still in state of '" + state + "'"));
                break;
            }
            case MUST_ABORT: {
                Assert.fail((String)("Transaction is still in state of '" + state + "'"));
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    @Deprecated
    public void commitTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            Assert.fail((String)"No transaction exists");
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case COMMITTED: 
            case ABORTED: 
            case MUST_ABORT: {
                Assert.fail((String)("Transaction is in state of '" + state + "'"));
                break;
            }
            case IN_PROGRESS: {
                transactionManager.endTransaction();
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    @Deprecated
    public void abortTran() {
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        if (transaction == null) {
            Assert.fail((String)"No transaction exists");
            return;
        }
        IsisTransaction.State state = transaction.getState();
        switch (state) {
            case ABORTED: {
                break;
            }
            case COMMITTED: {
                Assert.fail((String)("Transaction is in state of '" + state + "'"));
                break;
            }
            case IN_PROGRESS: 
            case MUST_ABORT: {
                transactionManager.abortTransaction();
                break;
            }
            default: {
                Assert.fail((String)("Unknown transaction state '" + state + "'"));
            }
        }
    }

    public <T> T getService(Class<T> serviceClass) {
        ServicesInjector servicesInjector = this.isisSessionFactory.getServicesInjector();
        return (T)servicesInjector.lookupServiceElseFail(serviceClass);
    }

    public <T> void replaceService(T originalService, T replacementService) {
        ServicesInjector servicesInjector = this.isisSessionFactory.getServicesInjector();
        servicesInjector.replaceService(originalService, replacementService);
    }

    @Deprecated
    public void installFixtures(InstallableFixture ... fixtures) {
        FixturesInstallerDelegate fid = new FixturesInstallerDelegate(this.isisSessionFactory);
        for (InstallableFixture fixture : fixtures) {
            fid.addFixture((Object)fixture);
        }
        fid.installFixtures();
        IsisTransactionManager transactionManager = this.getTransactionManager();
        IsisTransaction transaction = transactionManager.getCurrentTransaction();
        IsisTransaction.State transactionState = transaction.getState();
        if (transactionState.canCommit()) {
            this.commitTran();
            try {
                this.nextSession();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.beginTran();
        }
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    private PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    private static enum FireListeners {
        FIRE,
        DONT_FIRE;


        public boolean shouldFire() {
            return this == FIRE;
        }
    }

    public static class Builder {
        private AuthenticationRequest authenticationRequest = new AuthenticationRequestNameOnly("tester");
        private IsisConfigurationDefault configuration = new IsisConfigurationDefault();
        private AppManifest appManifestIfAny;
        private final List<Object> services = Lists.newArrayList();
        private final List<InstallableFixture> fixtures = Lists.newArrayList();
        private final List<Listener> listeners = Lists.newArrayList();
        private Level level;

        public Builder with(IsisConfiguration configuration) {
            this.configuration = (IsisConfigurationDefault)configuration;
            return this;
        }

        public Builder with(AuthenticationRequest authenticationRequest) {
            this.authenticationRequest = authenticationRequest;
            return this;
        }

        public Builder with(AppManifest appManifest) {
            this.appManifestIfAny = appManifest;
            return this;
        }

        public Builder withLoggingAt(Level level) {
            this.level = level;
            return this;
        }

        public IsisSystemForTest build() {
            final IsisSystemForTest isisSystemForTest = new IsisSystemForTest(this.appManifestIfAny, (IsisConfiguration)this.configuration, this.authenticationRequest, this.listeners);
            if (this.level != null) {
                isisSystemForTest.setLevel(this.level);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public synchronized void run() {
                    try {
                        isisSystemForTest.closeSession();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (isisSystemForTest.isisSessionFactory != null) {
                            isisSystemForTest.isisSessionFactory.destroyServicesAndShutdown();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return isisSystemForTest;
        }

        public Builder with(Listener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
            return this;
        }
    }

    public static abstract class ListenerAdapter
    implements Listener {
        private IsisConfiguration configuration;

        @Override
        public void init(IsisConfiguration configuration) throws Exception {
            this.configuration = configuration;
        }

        protected IsisConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public void preOpenSession(boolean firstTime) throws Exception {
        }

        @Override
        public void postOpenSession(boolean firstTime) throws Exception {
        }

        @Override
        public void preNextSession() throws Exception {
        }

        @Override
        public void postNextSession() throws Exception {
        }

        @Override
        public void preCloseSession() throws Exception {
        }

        @Override
        public void postCloseSession() throws Exception {
        }
    }

    public static interface Listener {
        public void init(IsisConfiguration var1) throws Exception;

        public void preOpenSession(boolean var1) throws Exception;

        public void postOpenSession(boolean var1) throws Exception;

        public void preNextSession() throws Exception;

        public void postNextSession() throws Exception;

        public void preCloseSession() throws Exception;

        public void postCloseSession() throws Exception;
    }
}

