/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class Log4jLogger {
    public static final String PROPERTY_ROOT = "isis.logging.";
    private Logger logger;
    private final Level level;

    public Log4jLogger() {
        this(Level.DEBUG);
    }

    public Log4jLogger(String level) {
        this.level = Level.toLevel((String)level);
    }

    public Log4jLogger(Level level) {
        this.level = level;
    }

    protected abstract Class<?> getDecoratedClass();

    public void log(String message) {
        this.logger().log((Priority)this.level, (Object)message);
    }

    public void log(String request, Object result) {
        this.log(request + "  -> " + result);
    }

    private Logger logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getDecoratedClass());
        }
        return this.logger;
    }
}

