/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import java.io.UnsupportedEncodingException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;

public class SmtpExtendedAppender
extends SMTPAppender {
    public SmtpExtendedAppender() {
    }

    public SmtpExtendedAppender(TriggeringEventEvaluator evaluator) {
        super(evaluator);
    }

    public void append(LoggingEvent event) {
        if (this.evaluator.isTriggeringEvent(event)) {
            try {
                String subject = this.limitToFirstLine(String.valueOf(event.getMessage()));
                String encodedSubject = MimeUtility.encodeText((String)subject, (String)"UTF-8", null);
                this.msg.setSubject(encodedSubject);
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        super.append(event);
    }

    private String limitToFirstLine(String subject) {
        int newline = subject.indexOf(10);
        int carriageReturn = subject.indexOf(13);
        if (newline != -1 || carriageReturn != -1) {
            int pos = Math.max(newline, carriageReturn);
            subject = subject.substring(0, pos);
        }
        return subject;
    }
}

