/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.authentication;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageBroker
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> messages = Lists.newArrayList();
    private final List<String> warnings = Lists.newArrayList();
    private String applicationError;

    public void reset() {
        this.warnings.clear();
        this.messages.clear();
        this.applicationError = null;
    }

    public List<String> getMessages() {
        return this.copyAndClear(this.messages);
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public List<String> getWarnings() {
        return this.copyAndClear(this.warnings);
    }

    public void addWarning(String message) {
        this.warnings.add(message);
    }

    public String getApplicationError() {
        String error = this.applicationError;
        this.setApplicationError(null);
        return error;
    }

    public void setApplicationError(String applicationError) {
        this.applicationError = applicationError;
    }

    private List<String> copyAndClear(List<String> messages) {
        List<String> copy = Collections.unmodifiableList(new ArrayList<String>(messages));
        messages.clear();
        return copy;
    }
}

