/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.configbuilder;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.commons.configbuilder.PrimerForEnvironmentVariableISIS_OPT;
import org.apache.isis.core.commons.configbuilder.PrimerForEnvironmentVariablesIsisPrefix;
import org.apache.isis.core.commons.configbuilder.PrimerForSystemProperties;
import org.apache.isis.core.commons.configbuilder.PropertiesReader;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.resource.ResourceStreamSource;
import org.apache.isis.core.commons.resource.ResourceStreamSourceChainOfResponsibility;
import org.apache.isis.core.commons.resource.ResourceStreamSourceFileSystem;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IsisConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(IsisConfigurationBuilder.class);
    private final ResourceStreamSourceChainOfResponsibility resourceStreamSourceChain;
    final IsisConfigurationDefault configuration;
    private boolean locked;
    private final Set<String> configurationResourcesFound = Sets.newLinkedHashSet();
    private final Set<String> configurationResourcesNotFound = Sets.newLinkedHashSet();

    public IsisConfigurationBuilder() {
        this(ResourceStreamSourceFileSystem.create("config"));
    }

    public IsisConfigurationBuilder(ResourceStreamSource ... resourceStreamSources) {
        this(IsisConfigurationBuilder.createComposite(Arrays.asList(resourceStreamSources)));
    }

    public IsisConfigurationBuilder(List<ResourceStreamSource> resourceStreamSources) {
        this(IsisConfigurationBuilder.createComposite(resourceStreamSources));
    }

    public IsisConfigurationBuilder(ResourceStreamSourceChainOfResponsibility resourceStreamSourceChain) {
        this.resourceStreamSourceChain = resourceStreamSourceChain;
        this.configuration = new IsisConfigurationDefault(resourceStreamSourceChain);
    }

    private static ResourceStreamSourceChainOfResponsibility createComposite(List<ResourceStreamSource> resourceStreamSources) {
        ResourceStreamSourceChainOfResponsibility composite = new ResourceStreamSourceChainOfResponsibility(new ResourceStreamSource[0]);
        for (ResourceStreamSource rss : resourceStreamSources) {
            if (rss == null) continue;
            composite.addResourceStreamSource(rss);
        }
        return composite;
    }

    public void addDefaultConfigurationResourcesAndPrimers() {
        this.addDefaultConfigurationResources();
        this.addDefaultPrimers();
    }

    private void addDefaultConfigurationResources() {
        IsisConfigurationDefault.ContainsPolicy ignorePolicy = IsisConfigurationDefault.ContainsPolicy.IGNORE;
        NotFoundPolicy continuePolicy = NotFoundPolicy.CONTINUE;
        this.addConfigurationResource("isis.properties", NotFoundPolicy.FAIL_FAST, ignorePolicy);
        this.addConfigurationResource("web.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("war.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("viewer_wicket.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("viewer_restful.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("viewer_restfulobjects.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("persistor_datanucleus.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("persistor.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authentication_shiro.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authentication_bypass.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authentication.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authorization_shiro.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authorization_bypass.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("authorization.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("reflector_java.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("reflector.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("fixtures-installer_configuration.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("fixtures-installer.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer_annotation.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer_configuration.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer_configuration-and-annotation.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("services-installer.properties", continuePolicy, ignorePolicy);
        this.addConfigurationResource("override.properties", NotFoundPolicy.CONTINUE, IsisConfigurationDefault.ContainsPolicy.OVERWRITE);
        this.addConfigurationResource("overrides.properties", NotFoundPolicy.CONTINUE, IsisConfigurationDefault.ContainsPolicy.OVERWRITE);
    }

    private void addDefaultPrimers() {
        this.primeWith(new PrimerForSystemProperties());
        this.primeWith(new PrimerForEnvironmentVariablesIsisPrefix());
        this.primeWith(new PrimerForEnvironmentVariableISIS_OPT());
    }

    public void addResourceStreamSource(ResourceStreamSource resourceStreamSource) {
        this.addResourceStreamSources(resourceStreamSource);
    }

    public void addResourceStreamSources(ResourceStreamSource ... resourceStreamSources) {
        this.addResourceStreamSources(Arrays.asList(resourceStreamSources));
    }

    public void addResourceStreamSources(List<ResourceStreamSource> resourceStreamSources) {
        this.ensureNotLocked();
        for (ResourceStreamSource resourceStreamSource : resourceStreamSources) {
            this.resourceStreamSourceChain.addResourceStreamSource(resourceStreamSource);
        }
    }

    public void addConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy, IsisConfigurationDefault.ContainsPolicy containsPolicy) {
        this.ensureNotLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("checking availability of configuration resource: %s, notFoundPolicy: %s", new Object[]{configurationResource, notFoundPolicy}));
        }
        this.loadConfigurationResource(configurationResource, notFoundPolicy, containsPolicy);
    }

    private void loadConfigurationResource(String configurationResource, NotFoundPolicy notFoundPolicy, IsisConfigurationDefault.ContainsPolicy containsPolicy) {
        try {
            PropertiesReader propertiesReader = this.loadConfigurationResource(this.resourceStreamSourceChain, configurationResource);
            LOG.info("loading properties from " + configurationResource);
            this.configuration.add(propertiesReader.getProperties(), containsPolicy);
            this.configurationResourcesFound.add(configurationResource);
            return;
        }
        catch (IOException ignore) {
            if (notFoundPolicy == NotFoundPolicy.FAIL_FAST) {
                throw new IsisException(String.format("failed to load '%s'; tried using: %s", configurationResource, this.resourceStreamSourceChain.getName()));
            }
            this.configurationResourcesNotFound.add(configurationResource);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("'%s' not found, but not needed", configurationResource));
            }
            return;
        }
    }

    private PropertiesReader loadConfigurationResource(ResourceStreamSource resourceStreamSource, String configurationResource) throws IOException {
        return new PropertiesReader(resourceStreamSource, configurationResource);
    }

    public void add(String key, String value) {
        this.ensureNotLocked();
        this.configuration.add(key, value);
    }

    public void put(String key, String value) {
        this.ensureNotLocked();
        this.configuration.put(key, value);
    }

    public boolean parseAndPrimeWith(List<OptionHandler> optionHandlers, String[] args) {
        Options options = new Options();
        for (OptionHandler optionHandler : optionHandlers) {
            optionHandler.addOption(options);
        }
        boolean parsedOk = this.parseAndPrimeWith(options, optionHandlers, args);
        if (parsedOk) {
            for (OptionHandler optionHandler : optionHandlers) {
                this.primeWith(optionHandler);
            }
        }
        return parsedOk;
    }

    private boolean parseAndPrimeWith(Options options, List<OptionHandler> optionHandlers, String[] args) {
        BootPrinter printer = new BootPrinter(this.getClass());
        BasicParser parser = new BasicParser();
        try {
            CommandLine commandLine = parser.parse(options, args);
            for (OptionHandler optionHandler : optionHandlers) {
                if (optionHandler.handle(commandLine, printer, options)) continue;
                return false;
            }
        }
        catch (ParseException e) {
            printer.printErrorMessage(e.getMessage());
            printer.printHelp(options);
            return false;
        }
        return true;
    }

    public void primeWith(Primer primer) {
        this.ensureNotLocked();
        LOG.debug("priming configurations for '{}'", (Object)primer);
        primer.prime(this);
    }

    public IsisConfigurationDefault getConfiguration() {
        if (!this.locked) {
            this.locked = true;
            this.dumpResourcesToLog();
        }
        return this.configuration;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public IsisConfiguration peekConfiguration() {
        IsisConfigurationDefault cfg = new IsisConfigurationDefault(this.resourceStreamSourceChain);
        Properties props = new Properties();
        props.putAll(this.configuration.asMap());
        cfg.add(props, IsisConfigurationDefault.ContainsPolicy.OVERWRITE);
        return cfg;
    }

    private void ensureNotLocked() {
        if (this.locked) {
            throw new IsisException("Configuration has been locked and cannot be changed");
        }
    }

    public void dumpResourcesToLog() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuration resources FOUND:");
            for (String resource : this.configurationResourcesFound) {
                LOG.debug("*  {}", (Object)resource);
            }
            LOG.debug("Configuration resources NOT FOUND (but not needed):");
            for (String resource : this.configurationResourcesNotFound) {
                LOG.debug("*  {}", (Object)resource);
            }
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("resourceStream", (Object)this.resourceStreamSourceChain).add("configResources", this.configurationResourcesFound).toString();
    }

    public static interface Primer {
        public void prime(IsisConfigurationBuilder var1);
    }
}

