/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.configbuilder;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.configbuilder.IsisConfigurationBuilder;

public class PrimerForEnvironmentVariableISIS_OPT
implements IsisConfigurationBuilder.Primer {
    public static final String OPT_ENV = "ISIS_OPTS";
    public static final String SEPARATOR_ENV = "ISIS_OPTS_SEPARATOR";
    public static final String SEPARATOR_DEFAULT = "||";

    @Override
    public void prime(IsisConfigurationBuilder builder) {
        String separator = PrimerForEnvironmentVariableISIS_OPT.determineSeparator();
        String env = System.getenv(OPT_ENV);
        for (Map.Entry<String, String> entry : PrimerForEnvironmentVariableISIS_OPT.fromEnv(env, separator).entrySet()) {
            String envVarName = entry.getKey();
            String envVarValue = entry.getValue();
            builder.put(envVarName, envVarValue);
        }
    }

    private static String determineSeparator() {
        String separator = System.getenv(SEPARATOR_ENV);
        if (separator != null) {
            return separator;
        }
        return SEPARATOR_DEFAULT;
    }

    private static Map<String, String> fromEnv(String env, String separator) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (env != null) {
            List keyAndValues = Splitter.on((String)separator).splitToList((CharSequence)env);
            for (String keyAndValue : keyAndValues) {
                List parts = Splitter.on((String)"=").splitToList((CharSequence)keyAndValue);
                if (parts.size() != 2) continue;
                map.put(parts.get(0), parts.get(1));
            }
        }
        return map;
    }
}

