/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.encoding;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.commons.encoding.FieldType;

public class DataOutputStreamExtended
implements DataOutputExtended {
    private final DataOutputStream dataOutputStream;

    public DataOutputStreamExtended(OutputStream output) {
        this.dataOutputStream = new DataOutputStream(output);
    }

    @Override
    public DataOutputStream getDataOutputStream() {
        return this.dataOutputStream;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        FieldType.BOOLEAN.write(this, value);
    }

    @Override
    public void writeBooleans(boolean[] value) throws IOException {
        FieldType.BOOLEAN_ARRAY.write(this, value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        FieldType.CHAR.write(this, Character.valueOf((char)value));
    }

    @Override
    public void writeChars(char[] value) throws IOException {
        FieldType.CHAR_ARRAY.write(this, value);
    }

    @Override
    public void write(int value) throws IOException {
        this.writeByte((byte)value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        FieldType.BYTE.write(this, (byte)value);
    }

    @Override
    public void write(byte[] value) throws IOException {
        this.writeBytes(value);
    }

    @Override
    public void writeBytes(byte[] value) throws IOException {
        FieldType.BYTE_ARRAY.write(this, value);
    }

    @Override
    public void writeShort(int value) throws IOException {
        FieldType.SHORT.write(this, (short)value);
    }

    @Override
    public void writeShorts(short[] value) throws IOException {
        FieldType.SHORT_ARRAY.write(this, value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        FieldType.INTEGER.write(this, value);
    }

    @Override
    public void writeInts(int[] value) throws IOException {
        FieldType.INTEGER_ARRAY.write(this, value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        FieldType.LONG.write(this, value);
    }

    @Override
    public void writeLongs(long[] value) throws IOException {
        FieldType.LONG_ARRAY.write(this, value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        FieldType.FLOAT.write(this, Float.valueOf(value));
    }

    @Override
    public void writeFloats(float[] value) throws IOException {
        FieldType.FLOAT_ARRAY.write(this, value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        FieldType.DOUBLE.write(this, value);
    }

    @Override
    public void writeDoubles(double[] value) throws IOException {
        FieldType.DOUBLE_ARRAY.write(this, value);
    }

    @Override
    public void writeUTF(String value) throws IOException {
        FieldType.STRING.write(this, value);
    }

    @Override
    public void writeUTFs(String[] value) throws IOException {
        FieldType.STRING_ARRAY.write(this, value);
    }

    @Override
    public void writeEncodable(Object encodable) throws IOException {
        FieldType.ENCODABLE.write(this, (Encodable)encodable);
    }

    @Override
    public void writeEncodables(Object[] objects) throws IOException {
        Encodable[] encodables;
        if (objects == null) {
            encodables = null;
        } else {
            encodables = new Encodable[objects.length];
            for (int i = 0; i < encodables.length; ++i) {
                encodables[i] = (Encodable)objects[i];
            }
        }
        FieldType.ENCODABLE_ARRAY.write(this, encodables);
    }

    @Override
    public void writeSerializable(Object serializable) throws IOException {
        FieldType.SERIALIZABLE.write(this, (Serializable)serializable);
    }

    @Override
    public void writeSerializables(Object[] objects) throws IOException {
        Serializable[] serializeables;
        if (objects == null) {
            serializeables = null;
        } else {
            serializeables = new Serializable[objects.length];
            for (int i = 0; i < serializeables.length; ++i) {
                serializeables[i] = (Serializable)objects[i];
            }
        }
        FieldType.SERIALIZABLE_ARRAY.write(this, serializeables);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOutputStream.write(b, off, len);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.dataOutputStream.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.dataOutputStream.writeChars(str);
    }

    @Override
    public void flush() throws IOException {
        this.dataOutputStream.flush();
    }
}

