/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.annotation.When;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.MethodUtil;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectVisibilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ElementSpecificationProvider;
import org.apache.isis.core.metamodel.spec.Instance;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.Specification;

public interface ObjectAdapter
extends Instance,
When.Persistable {
    @Override
    public ObjectSpecification getSpecification();

    public Object getObject();

    @Deprecated
    public String titleString();

    public String titleString(ObjectAdapter var1);

    public Instance getInstance(Specification var1);

    public void replacePojo(Object var1);

    public ObjectSpecification getElementSpecification();

    public void setElementSpecificationProvider(ElementSpecificationProvider var1);

    public String getIconName();

    public void checkLock(Version var1);

    public Oid getOid();

    public void replaceOid(Oid var1);

    public ObjectAdapter getAggregateRoot();

    public Version getVersion();

    public void setVersion(Version var1);

    public boolean isParentedCollection();

    public boolean isValue();

    public boolean representsPersistent();

    public boolean isDestroyed();

    public static class Functions {
        private Functions() {
        }

        public static Function<ObjectAdapter, Object> getObject() {
            return new Function<ObjectAdapter, Object>(){

                public Object apply(ObjectAdapter input) {
                    return Util.unwrap(input);
                }
            };
        }

        public static Function<Object, ObjectAdapter> adapterForUsing(final AdapterManager adapterManager) {
            return new Function<Object, ObjectAdapter>(){

                public ObjectAdapter apply(Object pojo) {
                    return adapterManager.adapterFor(pojo);
                }
            };
        }
    }

    public static final class InvokeUtils {
        private InvokeUtils() {
        }

        public static void invokeAll(List<Method> methods, ObjectAdapter adapter) {
            MethodUtil.invoke(methods, Util.unwrap(adapter));
        }

        public static Object invoke(Method method, ObjectAdapter adapter) {
            return MethodExtensions.invoke(method, Util.unwrap(adapter));
        }

        public static Object invoke(Method method, ObjectAdapter adapter, Object arg0) {
            return MethodExtensions.invoke(method, Util.unwrap(adapter), new Object[]{arg0});
        }

        public static Object invoke(Method method, ObjectAdapter adapter, ObjectAdapter arg0Adapter) {
            return InvokeUtils.invoke(method, adapter, Util.unwrap(arg0Adapter));
        }

        public static Object invoke(Method method, ObjectAdapter adapter, ObjectAdapter[] argumentAdapters) {
            return MethodExtensions.invoke(method, Util.unwrap(adapter), Util.unwrap(argumentAdapters));
        }

        public static Object invoke(Method method, ObjectAdapter adapter, Map<Integer, ObjectAdapter> argumentAdapters) {
            return InvokeUtils.invoke(method, adapter, InvokeUtils.asArray(argumentAdapters, method.getParameterTypes().length));
        }

        private static ObjectAdapter[] asArray(Map<Integer, ObjectAdapter> argumentAdapters, int length) {
            ObjectAdapter[] args = new ObjectAdapter[length];
            for (Map.Entry<Integer, ObjectAdapter> entry : argumentAdapters.entrySet()) {
                Integer paramNum = entry.getKey();
                if (paramNum >= length) continue;
                args[paramNum.intValue()] = entry.getValue();
            }
            return args;
        }

        public static Object invokeAutofit(Method method, ObjectAdapter target, List<ObjectAdapter> argumentsIfAvailable, AdapterManager adapterManager) {
            ArrayList args = Lists.newArrayList();
            if (argumentsIfAvailable != null) {
                args.addAll(argumentsIfAvailable);
            }
            InvokeUtils.adjust(method, args, adapterManager);
            ObjectAdapter[] argArray = args.toArray(new ObjectAdapter[0]);
            return InvokeUtils.invoke(method, target, argArray);
        }

        private static void adjust(Method method, List<ObjectAdapter> args, AdapterManager adapterManager) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            ListExtensions.adjust(args, parameterTypes.length);
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> cls = parameterTypes[i];
                if (args.get(i) != null || !cls.isPrimitive()) continue;
                Object object = ClassExtensions.toDefault(cls);
                ObjectAdapter adapter = adapterManager.adapterFor(object);
                args.set(i, adapter);
            }
        }

        private static Object invokeWithDefaults(Method method, ObjectAdapter adapter, ObjectAdapter[] argumentAdapters) {
            ObjectAdapter[] adapters;
            int numParams = method.getParameterTypes().length;
            if (argumentAdapters == null || argumentAdapters.length == 0) {
                adapters = new ObjectAdapter[numParams];
            } else if (numParams == 0) {
                adapters = new ObjectAdapter[]{};
            } else if (argumentAdapters.length == numParams) {
                adapters = argumentAdapters;
            } else {
                throw new IllegalArgumentException("Method has " + numParams + " params but " + argumentAdapters.length + " arguments provided");
            }
            return InvokeUtils.invoke(method, adapter, adapters);
        }
    }

    public static final class Util {
        private Util() {
        }

        public static Object unwrap(ObjectAdapter adapter) {
            return adapter != null ? adapter.getObject() : null;
        }

        public static Object[] unwrap(ObjectAdapter[] adapters) {
            if (adapters == null) {
                return null;
            }
            Object[] unwrappedObjects = new Object[adapters.length];
            int i = 0;
            for (ObjectAdapter adapter : adapters) {
                unwrappedObjects[i++] = Util.unwrap(adapter);
            }
            return unwrappedObjects;
        }

        public static List<Object> unwrap(List<ObjectAdapter> adapters) {
            ArrayList objects = Lists.newArrayList();
            for (ObjectAdapter adapter : adapters) {
                objects.add(Util.unwrap(adapter));
            }
            return objects;
        }

        public static <T> List<T> unwrapT(List<ObjectAdapter> adapters) {
            return Util.unwrap(adapters);
        }

        public static String unwrapAsString(ObjectAdapter adapter) {
            Object obj = Util.unwrap(adapter);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof String)) {
                return null;
            }
            return (String)obj;
        }

        public static String titleString(ObjectAdapter adapter) {
            return adapter != null ? adapter.titleString(null) : "";
        }

        public static boolean exists(ObjectAdapter adapter) {
            return adapter != null && adapter.getObject() != null;
        }

        public static boolean wrappedEqual(ObjectAdapter adapter1, ObjectAdapter adapter2) {
            boolean defined1 = Util.exists(adapter1);
            boolean defined2 = Util.exists(adapter2);
            if (defined1 && !defined2) {
                return false;
            }
            if (!defined1 && defined2) {
                return false;
            }
            if (!defined1 && !defined2) {
                return true;
            }
            return adapter1.getObject().equals(adapter2.getObject());
        }

        public static boolean nullSafeEquals(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (obj1.equals(obj2)) {
                return true;
            }
            if (obj1 instanceof ObjectAdapter && obj2 instanceof ObjectAdapter) {
                ObjectAdapter adapterObj1 = (ObjectAdapter)obj1;
                ObjectAdapter adapterObj2 = (ObjectAdapter)obj2;
                return Util.nullSafeEquals(adapterObj1.getObject(), adapterObj2.getObject());
            }
            return false;
        }

        public static List<ObjectAdapter> visibleAdapters(ObjectAdapter collectionAdapter, InteractionInitiatedBy interactionInitiatedBy) {
            CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(collectionAdapter);
            Iterable<ObjectAdapter> objectAdapters = facet.iterable(collectionAdapter);
            return Util.visibleAdapters(objectAdapters, interactionInitiatedBy);
        }

        public static List<ObjectAdapter> visibleAdapters(Iterable<ObjectAdapter> objectAdapters, InteractionInitiatedBy interactionInitiatedBy) {
            ArrayList adapters = Lists.newArrayList();
            for (ObjectAdapter adapter : objectAdapters) {
                boolean visible = Util.isVisible(adapter, interactionInitiatedBy);
                if (!visible) continue;
                adapters.add(adapter);
            }
            return adapters;
        }

        public static boolean isVisible(ObjectAdapter adapter, InteractionInitiatedBy interactionInitiatedBy) {
            if (adapter == null) {
                return true;
            }
            if (adapter.isDestroyed()) {
                return false;
            }
            if (interactionInitiatedBy == InteractionInitiatedBy.FRAMEWORK) {
                return true;
            }
            return Util.isVisibleForUser(adapter);
        }

        private static boolean isVisibleForUser(ObjectAdapter adapter) {
            VisibilityContext<?> context = Util.createVisibleInteractionContextForUser(adapter);
            ObjectSpecification objectSpecification = adapter.getSpecification();
            InteractionResult visibleResult = InteractionUtils.isVisibleResult(objectSpecification, context);
            return visibleResult.isNotVetoing();
        }

        private static VisibilityContext<?> createVisibleInteractionContextForUser(ObjectAdapter objectAdapter) {
            return new ObjectVisibilityContext(objectAdapter, objectAdapter.getSpecification().getIdentifier(), InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        }
    }
}

