/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedCollectionOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;

public final class OidMarshaller {
    public static final OidMarshaller INSTANCE = new OidMarshaller();
    public static final String VIEWMODEL_INDICATOR = Bookmark.ObjectState.VIEW_MODEL.getCode();
    private static final String TRANSIENT_INDICATOR = Bookmark.ObjectState.TRANSIENT.getCode();
    private static final String SEPARATOR = ":";
    private static final String SEPARATOR_NESTING = "~";
    private static final String SEPARATOR_COLLECTION = "$";
    private static final String SEPARATOR_VERSION = "^";
    private static final String WORD = "[^:~$\\^#]+";
    private static final String DIGITS = "\\d+";
    private static final String WORD_GROUP = "([^:~$\\^#]+)";
    private static final String DIGITS_GROUP = "(\\d+)";
    private static Pattern OIDSTR_PATTERN = Pattern.compile("^((([" + TRANSIENT_INDICATOR + VIEWMODEL_INDICATOR + "])?" + "([^:~$\\^#]+)" + ":" + "([^:~$\\^#]+)" + ")" + "(" + "(" + "~" + "[^:~$\\^#]+" + ":" + "[^:~$\\^#]+" + ")*" + ")" + ")" + "(" + "[" + "$" + "]" + "[^:~$\\^#]+" + ")?" + "(" + "[\\" + "^" + "]" + "(\\d+)" + ":" + "([^:~$\\^#]+)" + "?" + ":" + "(\\d+)" + "?" + ")?" + "$");

    private OidMarshaller() {
    }

    @Programmatic
    public String joinAsOid(String domainType, String instanceId) {
        return domainType + SEPARATOR + instanceId;
    }

    @Programmatic
    public String splitInstanceId(String oidStr) {
        int indexOfSeperator = oidStr.indexOf(SEPARATOR);
        return indexOfSeperator > 0 ? oidStr.substring(indexOfSeperator + 1) : null;
    }

    @Programmatic
    public <T extends Oid> T unmarshal(String oidStr, Class<T> requestedType) {
        String collectionPart;
        Matcher matcher = OIDSTR_PATTERN.matcher(oidStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Could not parse OID '" + oidStr + "'; should match pattern: " + OIDSTR_PATTERN.pattern());
        }
        String isTransientOrViewModelStr = this.getGroup(matcher, 3);
        Oid.State state = "!".equals(isTransientOrViewModelStr) ? Oid.State.TRANSIENT : ("*".equals(isTransientOrViewModelStr) ? Oid.State.VIEWMODEL : Oid.State.PERSISTENT);
        String rootObjectType = this.getGroup(matcher, 4);
        String rootIdentifier = this.getGroup(matcher, 5);
        String aggregateOidPart = this.getGroup(matcher, 6);
        ArrayList aggregateOidParts = Lists.newArrayList();
        Splitter nestingSplitter = Splitter.on((String)SEPARATOR_NESTING);
        Splitter partsSplitter = Splitter.on((String)SEPARATOR);
        if (aggregateOidPart != null) {
            Iterable tildaSplitIter = nestingSplitter.split((CharSequence)aggregateOidPart);
            for (String str : tildaSplitIter) {
                if (Strings.isNullOrEmpty((String)str)) continue;
                Iterator colonSplitIter = partsSplitter.split((CharSequence)str).iterator();
                String objectType = (String)colonSplitIter.next();
                String localId = (String)colonSplitIter.next();
                aggregateOidParts.add(new AggregateOidPart(objectType, localId));
            }
        }
        String collectionName = (collectionPart = this.getGroup(matcher, 8)) != null ? collectionPart.substring(1) : null;
        String versionSequence = this.getGroup(matcher, 10);
        String versionUser = this.getGroup(matcher, 11);
        String versionUtcTimestamp = this.getGroup(matcher, 12);
        Version version = Version.create(versionSequence, versionUser, versionUtcTimestamp);
        if (collectionName == null) {
            if (aggregateOidParts.isEmpty()) {
                this.ensureCorrectType(oidStr, requestedType, RootOid.class);
                return (T)new RootOid(ObjectSpecId.of(rootObjectType), rootIdentifier, state, version);
            }
            throw new RuntimeException("Aggregated Oids are no longer supported");
        }
        String oidStrWithoutCollectionName = this.getGroup(matcher, 1);
        String parentOidStr = oidStrWithoutCollectionName + this.marshal(version);
        RootOid parentOid = this.unmarshal(parentOidStr, RootOid.class);
        this.ensureCorrectType(oidStr, requestedType, ParentedCollectionOid.class);
        return (T)new ParentedCollectionOid(parentOid, collectionName);
    }

    private <T> void ensureCorrectType(String oidStr, Class<T> requestedType, Class<? extends Oid> actualType) {
        if (!requestedType.isAssignableFrom(actualType)) {
            throw new IllegalArgumentException("OID '" + oidStr + "' does not represent a " + actualType.getSimpleName());
        }
    }

    private String getGroup(Matcher matcher, int group) {
        int groupCount = matcher.groupCount();
        if (group > groupCount) {
            return null;
        }
        String val = matcher.group(group);
        return Strings.emptyToNull((String)val);
    }

    @Programmatic
    public final String marshal(RootOid rootOid) {
        return this.marshalNoVersion(rootOid) + this.marshal(rootOid.getVersion());
    }

    @Programmatic
    public final String marshalNoVersion(RootOid rootOid) {
        String transientIndicator = rootOid.isTransient() ? TRANSIENT_INDICATOR : "";
        String viewModelIndicator = rootOid.isViewModel() ? VIEWMODEL_INDICATOR : "";
        return transientIndicator + viewModelIndicator + rootOid.getObjectSpecId() + SEPARATOR + rootOid.getIdentifier();
    }

    @Programmatic
    public final String marshal(ParentedCollectionOid collectionOid) {
        return this.marshalNoVersion(collectionOid) + this.marshal(collectionOid.getVersion());
    }

    @Programmatic
    public String marshalNoVersion(ParentedCollectionOid collectionOid) {
        return collectionOid.getRootOid().enStringNoVersion() + SEPARATOR_COLLECTION + collectionOid.getName();
    }

    @Programmatic
    public final String marshal(Version version) {
        if (version == null) {
            return "";
        }
        String versionUser = version.getUser();
        return SEPARATOR_VERSION + version.getSequence() + SEPARATOR + Strings.nullToEmpty((String)versionUser) + SEPARATOR + OidMarshaller.nullToEmpty(version.getUtcTimestamp());
    }

    private static String nullToEmpty(Object obj) {
        return obj == null ? "" : "" + obj;
    }

    private static class AggregateOidPart {
        String objectType;
        String localId;

        AggregateOidPart(String objectType, String localId) {
            this.objectType = objectType;
            this.localId = localId;
        }

        public String toString() {
            return OidMarshaller.SEPARATOR_NESTING + this.objectType + OidMarshaller.SEPARATOR + this.localId;
        }
    }
}

