/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServicesInjectorAware;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public abstract class FacetFactoryAbstract
implements FacetFactory,
ServicesInjectorAware {
    private final List<FeatureType> featureTypes;
    protected ServicesInjector servicesInjector;

    public FacetFactoryAbstract(List<FeatureType> featureTypes) {
        this.featureTypes = ImmutableList.copyOf(featureTypes);
    }

    @Override
    public List<FeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        this.servicesInjector = servicesInjector;
    }

    protected SpecificationLoader getSpecificationLoader() {
        return this.servicesInjector.getSpecificationLoader();
    }

    protected AuthenticationSessionProvider getAuthenticationSessionProvider() {
        return this.servicesInjector.getAuthenticationSessionProvider();
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.servicesInjector.getDeploymentCategoryProvider().getDeploymentCategory();
    }

    protected IsisConfiguration getConfiguration() {
        ConfigurationServiceInternal configurationServiceInternal = this.servicesInjector.getConfigurationServiceInternal();
        return configurationServiceInternal;
    }
}

