/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.ActionSemantics;
import org.apache.isis.applib.annotation.Command;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.applib.services.eventbus.AbstractDomainEvent;
import org.apache.isis.applib.services.eventbus.ActionDomainEvent;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.metamodel.MetaModelService2;
import org.apache.isis.applib.services.queryresultscache.QueryResultsCache;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.commons.lang.ThrowableExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.DomainEventHelper;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.ElementSpecificationProviderFromTypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.ActionInvocationFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.ixn.InteractionDtoServiceInternal;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.metamodel.services.transtate.TransactionStateProviderInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.ReflectiveActionException;
import org.apache.isis.core.metamodel.specloader.specimpl.MixedInMember2;
import org.apache.isis.core.metamodel.transactions.TransactionState;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.schema.ixn.v1.ActionInvocationDto;
import org.apache.isis.schema.ixn.v1.MemberExecutionDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionInvocationFacetForDomainEventAbstract
extends ActionInvocationFacetAbstract
implements ImperativeFacet {
    private static final Logger LOG = LoggerFactory.getLogger(ActionInvocationFacetForDomainEventAbstract.class);
    private final Method method;
    private final ObjectSpecification onType;
    private final ObjectSpecification returnType;
    private final PersistenceSessionServiceInternal persistenceSessionServiceInternal;
    private final DeploymentCategory deploymentCategory;
    private final AuthenticationSessionProvider authenticationSessionProvider;
    private final ServicesInjector servicesInjector;
    private final IsisConfiguration configuration;
    private final TransactionStateProviderInternal transactionStateProviderInternal;
    private final Class<? extends ActionDomainEvent<?>> eventType;
    private final DomainEventHelper domainEventHelper;

    public ActionInvocationFacetForDomainEventAbstract(Class<? extends ActionDomainEvent<?>> eventType, Method method, ObjectSpecification onType, ObjectSpecification returnType, FacetHolder holder, ServicesInjector servicesInjector) {
        super(holder);
        this.eventType = eventType;
        this.method = method;
        this.onType = onType;
        this.returnType = returnType;
        this.deploymentCategory = servicesInjector.getDeploymentCategoryProvider().getDeploymentCategory();
        this.authenticationSessionProvider = servicesInjector.getAuthenticationSessionProvider();
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
        this.servicesInjector = servicesInjector;
        this.configuration = servicesInjector.getConfigurationServiceInternal();
        this.transactionStateProviderInternal = servicesInjector.lookupService(TransactionStateProviderInternal.class);
        this.domainEventHelper = new DomainEventHelper(this.servicesInjector);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.EXECUTE;
    }

    @Override
    public ObjectSpecification getReturnType() {
        return this.returnType;
    }

    @Override
    public ObjectSpecification getOnType() {
        return this.onType;
    }

    @Override
    public ObjectAdapter invoke(final ObjectAction owningAction, final ObjectAdapter targetAdapter, final ObjectAdapter mixedInAdapter, final ObjectAdapter[] argumentAdapters, final InteractionInitiatedBy interactionInitiatedBy) {
        final ObjectAdapter[] holder = new ObjectAdapter[1];
        this.getPersistenceSessionServiceInternal().executeWithinTransaction(new TransactionalClosure(){

            @Override
            public void execute() {
                holder[0] = ActionInvocationFacetForDomainEventAbstract.this.doInvoke(owningAction, targetAdapter, mixedInAdapter, argumentAdapters, interactionInitiatedBy);
            }
        });
        return holder[0];
    }

    ObjectAdapter doInvoke(final ObjectAction owningAction, final ObjectAdapter targetAdapter, final ObjectAdapter mixedInAdapter, final ObjectAdapter[] argumentAdapters, InteractionInitiatedBy interactionInitiatedBy) {
        ObjectAdapter returnedAdapter;
        CommandContext commandContext = this.getCommandContext();
        final Command command = commandContext.getCommand();
        InteractionContext interactionContext = this.getInteractionContext();
        Interaction interaction = interactionContext.getInteraction();
        String actionId = owningAction.getIdentifier().toClassAndNameIdentityString();
        if (command.getExecutor() == Command.Executor.USER && command.getExecuteIn() == Command.ExecuteIn.BACKGROUND) {
            CommandService commandService = this.getCommandService();
            if (!commandService.persistIfPossible(command)) {
                throw new IsisException(String.format("Unable to persist command for action '%s'; CommandService does not support persistent commands ", actionId));
            }
            returnedAdapter = this.getPersistenceSessionServiceInternal().adapterFor(command);
        } else {
            final ObjectAdapter mixinElseRegularAdapter = mixedInAdapter != null ? mixedInAdapter : targetAdapter;
            owningAction.setupBulkActionInvocationContext(mixinElseRegularAdapter);
            Object mixinElseRegularPojo = ObjectAdapter.Util.unwrap(mixinElseRegularAdapter);
            final List<ObjectAdapter> argumentAdapterList = Arrays.asList(argumentAdapters);
            List<Object> argumentPojos = ObjectAdapter.Util.unwrap(argumentAdapterList);
            String targetMember = ActionInvocationFacetForDomainEventAbstract.targetNameFor(owningAction, mixedInAdapter);
            String targetClass = CommandUtil.targetClassNameFor(mixinElseRegularAdapter);
            final Interaction.ActionInvocation execution = new Interaction.ActionInvocation(interaction, actionId, mixinElseRegularPojo, argumentPojos, targetMember, targetClass);
            Interaction.MemberExecutor<Interaction.ActionInvocation> callable = new Interaction.MemberExecutor<Interaction.ActionInvocation>(){

                public Object execute(Interaction.ActionInvocation currentExecution) {
                    try {
                        ActionInvocationDto invocationDto = ActionInvocationFacetForDomainEventAbstract.this.getInteractionDtoServiceInternal().asActionInvocationDto(owningAction, mixinElseRegularAdapter, argumentAdapterList);
                        currentExecution.setDto((MemberExecutionDto)invocationDto);
                        Timestamp startedAt = ActionInvocationFacetForDomainEventAbstract.this.getClockService().nowAsJavaSqlTimestamp();
                        execution.setStartedAt(startedAt);
                        if (command.getStartedAt() == null) {
                            command.setStartedAt(startedAt);
                        }
                        ActionDomainEvent<?> event = ActionInvocationFacetForDomainEventAbstract.this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.EXECUTING, ActionInvocationFacetForDomainEventAbstract.this.eventType, null, owningAction, owningAction, targetAdapter, mixedInAdapter, argumentAdapters, command, null);
                        currentExecution.setEvent(event);
                        Object resultPojo = ActionInvocationFacetForDomainEventAbstract.this.invokeMethodElseFromCache(targetAdapter, argumentAdapters);
                        ObjectAdapter resultAdapterPossiblyCloned = ActionInvocationFacetForDomainEventAbstract.this.cloneIfViewModelCloneable(resultPojo, mixinElseRegularAdapter);
                        ActionInvocationFacetForDomainEventAbstract.this.domainEventHelper.postEventForAction(AbstractDomainEvent.Phase.EXECUTED, ActionInvocationFacetForDomainEventAbstract.this.eventType, ActionInvocationFacetForDomainEventAbstract.this.verify(event), owningAction, owningAction, targetAdapter, mixedInAdapter, argumentAdapters, command, resultAdapterPossiblyCloned);
                        return ObjectAdapter.Util.unwrap(resultAdapterPossiblyCloned);
                    }
                    catch (IllegalAccessException ex) {
                        throw new ReflectiveActionException("Illegal access of " + ActionInvocationFacetForDomainEventAbstract.this.method, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable targetException = ex.getTargetException();
                        if (targetException instanceof IllegalStateException) {
                            throw new ReflectiveActionException(String.format("IllegalStateException thrown while executing %s %s", ActionInvocationFacetForDomainEventAbstract.this.method, targetException.getMessage()), targetException);
                        }
                        if (targetException instanceof RecoverableException && !ActionInvocationFacetForDomainEventAbstract.this.getTransactionState().canCommit()) {
                            Throwable targetExceptionCause = targetException.getCause();
                            Throwable nonRecoverableCause = targetExceptionCause != null ? targetExceptionCause : targetException;
                            String message = ActionInvocationFacetForDomainEventAbstract.trim(nonRecoverableCause.getMessage(), 300);
                            throw new NonRecoverableException(message, nonRecoverableCause);
                        }
                        ThrowableExtensions.throwWithinIsisException(ex, "Exception executing " + ActionInvocationFacetForDomainEventAbstract.this.method);
                        return null;
                    }
                }
            };
            interaction.execute((Interaction.MemberExecutor)callable, execution);
            Interaction.Execution priorExecution = interaction.getPriorExecution();
            Exception executionExceptionIfAny = priorExecution.getThrew();
            if (executionExceptionIfAny != null) {
                throw executionExceptionIfAny instanceof RuntimeException ? (RuntimeException)executionExceptionIfAny : new RuntimeException(executionExceptionIfAny);
            }
            Object returnedPojo = priorExecution.getReturned();
            returnedAdapter = this.persistenceSessionServiceInternal.adapterFor(returnedPojo);
            this.getInteractionDtoServiceInternal().updateResult((ActionInvocationDto)priorExecution.getDto(), owningAction, returnedPojo);
            this.setCommandResultIfEntity(command, returnedAdapter);
            PublishedActionFacet publishedActionFacet = this.getIdentified().getFacet(PublishedActionFacet.class);
            if (publishedActionFacet != null) {
                IdentifiedHolder identifiedHolder = this.getIdentified();
                List<ObjectAdapter> parameterAdapters = Arrays.asList(argumentAdapters);
                this.getPublishingServiceInternal().publishAction(priorExecution, owningAction, identifiedHolder, targetAdapter, parameterAdapters, returnedAdapter);
            }
        }
        return this.filteredIfRequired(returnedAdapter, interactionInitiatedBy);
    }

    private static String targetNameFor(ObjectAction owningAction, ObjectAdapter mixedInAdapter) {
        if (mixedInAdapter != null) {
            ObjectSpecification onType = owningAction.getOnType();
            ObjectSpecification mixedInSpec = mixedInAdapter.getSpecification();
            List<ObjectAction> objectActions1 = mixedInSpec.getObjectActions(Contributed.INCLUDED);
            for (ObjectAction objectAction : objectActions1) {
                MixedInMember2 action;
                if (!(objectAction instanceof MixedInMember2) || (action = (MixedInMember2)((Object)objectAction)).getMixinType() != onType) continue;
                return action.getName();
            }
        }
        return CommandUtil.targetMemberNameFor(owningAction);
    }

    private static String trim(String message, int maxLen) {
        if (!Strings.isNullOrEmpty((String)message) && (message = message.substring(0, Math.min(message.length(), maxLen))).length() == maxLen) {
            message = message + " ...";
        }
        return message;
    }

    protected Object invokeMethodElseFromCache(ObjectAdapter targetAdapter, ObjectAdapter[] arguments) throws IllegalAccessException, InvocationTargetException {
        boolean cacheable;
        final Object[] executionParameters = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            executionParameters[i] = ActionInvocationFacetForDomainEventAbstract.unwrap(arguments[i]);
        }
        final Object targetPojo = ActionInvocationFacetForDomainEventAbstract.unwrap(targetAdapter);
        ActionSemanticsFacet semanticsFacet = this.getFacetHolder().getFacet(ActionSemanticsFacet.class);
        boolean bl = cacheable = semanticsFacet != null && ((ActionSemantics.Of)semanticsFacet.value()).isSafeAndRequestCacheable();
        if (cacheable) {
            QueryResultsCache queryResultsCache = this.getQueryResultsCache();
            Object[] targetPojoPlusExecutionParameters = ArrayExtensions.appendT(executionParameters, targetPojo);
            return queryResultsCache.execute((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return ActionInvocationFacetForDomainEventAbstract.this.method.invoke(targetPojo, executionParameters);
                }
            }, targetPojo.getClass(), this.method.getName(), targetPojoPlusExecutionParameters);
        }
        return this.method.invoke(targetPojo, executionParameters);
    }

    protected ObjectAdapter cloneIfViewModelCloneable(Object resultPojo, ObjectAdapter targetAdapter) {
        if (resultPojo != null) {
            ObjectAdapter resultAdapter = this.getPersistenceSessionServiceInternal().adapterFor(resultPojo);
            return this.cloneIfViewModelElse(resultAdapter, resultAdapter);
        }
        return this.cloneIfViewModelElse(targetAdapter, null);
    }

    private ObjectAdapter cloneIfViewModelElse(ObjectAdapter adapter, ObjectAdapter dfltAdapter) {
        if (!adapter.getSpecification().isViewModelCloneable(adapter)) {
            return dfltAdapter;
        }
        ViewModelFacet viewModelFacet = adapter.getSpecification().getFacet(ViewModelFacet.class);
        Object clone = viewModelFacet.clone(adapter.getObject());
        ObjectAdapter clonedAdapter = this.getPersistenceSessionServiceInternal().adapterFor(clone);
        TypeOfFacet typeOfFacet = this.getFacetHolder().getFacet(TypeOfFacet.class);
        clonedAdapter.setElementSpecificationProvider(ElementSpecificationProviderFromTypeOfFacet.createFrom(typeOfFacet));
        return clonedAdapter;
    }

    protected void setCommandResultIfEntity(Command command, ObjectAdapter resultAdapter) {
        if (command.getResult() != null) {
            return;
        }
        if (resultAdapter == null) {
            return;
        }
        Class<?> domainType = resultAdapter.getSpecification().getCorrespondingClass();
        MetaModelService2.Sort sort = this.getMetaModelService().sortOf(domainType);
        switch (sort) {
            case JDO_ENTITY: {
                Object domainObject = resultAdapter.getObject();
                if (!this.getRepositoryService().isPersistent(domainObject)) {
                    this.getTransactionService().flushTransaction();
                }
                if (!this.getRepositoryService().isPersistent(domainObject)) break;
                BookmarkService bookmarkService = this.getBookmarkService();
                Bookmark bookmark = bookmarkService.bookmarkFor(domainObject);
                command.setResult(bookmark);
                break;
            }
        }
    }

    private MetaModelService2 getMetaModelService() {
        return this.servicesInjector.lookupServiceElseFail(MetaModelService2.class);
    }

    private TransactionService getTransactionService() {
        return this.servicesInjector.lookupServiceElseFail(TransactionService.class);
    }

    private BookmarkService getBookmarkService() {
        return this.servicesInjector.lookupServiceElseFail(BookmarkService.class);
    }

    private RepositoryService getRepositoryService() {
        return this.servicesInjector.lookupServiceElseFail(RepositoryService.class);
    }

    protected ObjectAdapter filteredIfRequired(ObjectAdapter resultAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        if (resultAdapter == null) {
            return null;
        }
        boolean filterForVisibility = this.getConfiguration().getBoolean("isis.reflector.facet.filterVisibility", true);
        if (!filterForVisibility) {
            return resultAdapter;
        }
        Object result = resultAdapter.getObject();
        if (result instanceof Collection || result.getClass().isArray()) {
            CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(resultAdapter);
            Iterable<ObjectAdapter> adapterList = facet.iterable(resultAdapter);
            List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(adapterList, interactionInitiatedBy);
            Object visibleObjects = CollectionUtils.copyOf(Lists.transform(visibleAdapters, ObjectAdapter.Functions.getObject()), this.method.getReturnType());
            if (visibleObjects != null) {
                return this.getPersistenceSessionServiceInternal().adapterFor(visibleObjects);
            }
            return resultAdapter;
        }
        boolean visible = ObjectAdapter.Util.isVisible(resultAdapter, interactionInitiatedBy);
        return visible ? resultAdapter : null;
    }

    protected ActionDomainEvent<?> verify(ActionDomainEvent<?> event) {
        return event;
    }

    public Class<? extends ActionDomainEvent<?>> getEventType() {
        return this.eventType;
    }

    private static Object unwrap(ObjectAdapter adapter) {
        return adapter == null ? null : adapter.getObject();
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    private CommandContext getCommandContext() {
        return this.servicesInjector.lookupServiceElseFail(CommandContext.class);
    }

    private InteractionContext getInteractionContext() {
        return this.servicesInjector.lookupServiceElseFail(InteractionContext.class);
    }

    private QueryResultsCache getQueryResultsCache() {
        return this.servicesInjector.lookupServiceElseFail(QueryResultsCache.class);
    }

    private CommandService getCommandService() {
        return this.servicesInjector.lookupServiceElseFail(CommandService.class);
    }

    private ClockService getClockService() {
        return this.servicesInjector.lookupServiceElseFail(ClockService.class);
    }

    private PublishingServiceInternal getPublishingServiceInternal() {
        return this.servicesInjector.lookupServiceElseFail(PublishingServiceInternal.class);
    }

    private InteractionDtoServiceInternal getInteractionDtoServiceInternal() {
        return this.servicesInjector.lookupServiceElseFail(InteractionDtoServiceInternal.class);
    }

    private PersistenceSessionServiceInternal getPersistenceSessionServiceInternal() {
        return this.persistenceSessionServiceInternal;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSessionProvider.getAuthenticationSession();
    }

    public TransactionState getTransactionState() {
        return this.transactionStateProviderInternal.getTransactionState();
    }
}

