/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.layout;

import java.util.Properties;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.actions.layout.ActionPositionFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.ActionPositionFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.BookmarkPolicyFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.BookmarkPolicyFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFaFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFaFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.CssClassFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.DescribedAsFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.DescribedAsFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.HiddenFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.HiddenFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.NamedFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.NamedFacetOnActionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.layout.NotContributedFacetForActionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.actions.layout.NotContributedFacetForLayoutProperties;
import org.apache.isis.core.metamodel.facets.actions.notcontributed.NotContributedFacet;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacet;
import org.apache.isis.core.metamodel.facets.actions.position.ActionPositionFacetFallback;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.facets.object.domainservice.DomainServiceFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ActionLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public ActionLayoutFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Object holder = processMethodContext.getFacetHolder();
        Properties properties = processMethodContext.metadataProperties("actionLayout");
        if (properties == null) {
            properties = processMethodContext.metadataProperties("layout");
        }
        ActionLayout actionLayout = Annotations.getAnnotation(processMethodContext.getMethod(), ActionLayout.class);
        BookmarkPolicyFacet bookmarkableFacet = BookmarkPolicyFacetOnActionFromLayoutProperties.create(properties, holder);
        if (bookmarkableFacet == null) {
            bookmarkableFacet = BookmarkPolicyFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        FacetUtil.addFacet(bookmarkableFacet);
        CssClassFacet cssClassFacet = CssClassFacetOnActionFromLayoutProperties.create(properties, holder);
        if (cssClassFacet == null) {
            cssClassFacet = CssClassFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        FacetUtil.addFacet(cssClassFacet);
        CssClassFaFacet cssClassFaFacet = CssClassFaFacetOnActionFromLayoutProperties.create(properties, holder);
        if (cssClassFaFacet == null) {
            cssClassFaFacet = CssClassFaFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        FacetUtil.addFacet(cssClassFaFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnActionFromLayoutProperties.create(properties, holder);
        if (describedAsFacet == null) {
            describedAsFacet = DescribedAsFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnActionFromLayoutProperties.create(properties, holder);
        if (hiddenFacet == null) {
            hiddenFacet = HiddenFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        FacetUtil.addFacet(hiddenFacet);
        NamedFacet namedFacet = NamedFacetOnActionFromLayoutProperties.create(properties, holder);
        if (namedFacet == null) {
            namedFacet = NamedFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        FacetUtil.addFacet(namedFacet);
        ActionPositionFacet actionPositionFacet = ActionPositionFacetOnActionFromLayoutProperties.create(properties, holder);
        if (actionPositionFacet == null) {
            actionPositionFacet = ActionPositionFacetForActionLayoutAnnotation.create(actionLayout, holder);
        }
        if (actionPositionFacet == null) {
            actionPositionFacet = new ActionPositionFacetFallback((FacetHolder)holder);
        }
        FacetUtil.addFacet(actionPositionFacet);
        if (this.isContributingServiceOrMixinObject(processMethodContext)) {
            NotContributedFacet notContributedFacet = NotContributedFacetForLayoutProperties.create(properties, holder);
            if (notContributedFacet == null) {
                notContributedFacet = NotContributedFacetForActionLayoutAnnotation.create(actionLayout, holder);
            }
            FacetUtil.addFacet(notContributedFacet);
        }
    }

    protected boolean isContributingServiceOrMixinObject(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> cls = processMethodContext.getCls();
        ObjectSpecification spec = this.getSpecificationLoader().loadSpecification(cls);
        return ActionLayoutFacetFactory.isContributingService(spec) || ActionLayoutFacetFactory.isMixinObject(spec);
    }

    private static boolean isContributingService(ObjectSpecification spec) {
        DomainServiceFacet domainServiceFacet = spec.getFacet(DomainServiceFacet.class);
        return domainServiceFacet != null && !domainServiceFacet.isNoop() && domainServiceFacet.getNatureOfService() != NatureOfService.VIEW_MENU_ONLY && domainServiceFacet.getNatureOfService() != NatureOfService.DOMAIN;
    }

    private static boolean isMixinObject(ObjectSpecification spec) {
        MixinFacet mixinFacet = spec.getFacet(MixinFacet.class);
        boolean b = mixinFacet != null && !mixinFacet.isNoop();
        return b;
    }

    protected boolean skipContributing(DomainServiceFacet domainServiceFacet) {
        return domainServiceFacet == null || domainServiceFacet.isNoop() || domainServiceFacet.getNatureOfService() == NatureOfService.VIEW_MENU_ONLY || domainServiceFacet.getNatureOfService() == NatureOfService.DOMAIN;
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Object holder = processMemberContext.getFacetHolder();
        Properties properties = processMemberContext.metadataProperties("actionLayout");
        if (properties == null) {
            properties = processMemberContext.metadataProperties("layout");
        }
        CssClassFacet cssClassFacet = CssClassFacetOnActionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(cssClassFacet);
        CssClassFaFacet cssClassFaFacet = CssClassFaFacetOnActionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(cssClassFaFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnActionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnActionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(hiddenFacet);
        NamedFacet namedFacet = NamedFacetOnActionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(namedFacet);
        ActionPositionFacet actionPositionFacet = ActionPositionFacetOnActionFromLayoutProperties.create(properties, holder);
        if (actionPositionFacet == null) {
            actionPositionFacet = new ActionPositionFacetFallback((FacetHolder)holder);
        }
        FacetUtil.addFacet(actionPositionFacet);
    }
}

