/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.all.i18n;

import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;

public class NamedFacetTranslated
extends FacetAbstract
implements NamedFacet {
    final TranslationService translationService;
    String context;
    String originalText;

    public NamedFacetTranslated(String context, String originalText, TranslationService translationService, IdentifiedHolder facetHolder) {
        super(NamedFacet.class, facetHolder, FacetAbstract.Derivation.NOT_DERIVED);
        this.context = context;
        this.originalText = originalText;
        this.translationService = translationService;
        if (translationService.getMode().isWrite()) {
            this.translateText();
        }
    }

    @Override
    public String value() {
        return this.translateText();
    }

    private String translateText() {
        return this.translationService.translate(this.context, this.originalText);
    }

    @Override
    public boolean escaped() {
        NamedFacet underlyingFacet = (NamedFacet)this.getUnderlyingFacet();
        return underlyingFacet != null && underlyingFacet.escaped();
    }
}

