/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.accessor;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacetAbstract;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class CollectionAccessorFacetViaAccessor
extends PropertyOrCollectionAccessorFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public CollectionAccessorFacetViaAccessor(Method method, FacetHolder holder, DeploymentCategory deploymentCategory, IsisConfiguration isisConfiguration, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager) {
        super(holder, deploymentCategory, isisConfiguration, specificationLoader, authenticationSessionProvider, adapterManager);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.ACCESSOR;
    }

    @Override
    public Object getProperty(ObjectAdapter owningAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        List<ObjectAdapter> visibleAdapters;
        Object visibleObjects;
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        ObjectAdapter collectionAdapter = this.getAdapterManager().adapterFor(collectionOrArray);
        boolean filterForVisibility = this.getConfiguration().getBoolean("isis.reflector.facet.filterVisibility", true);
        if (filterForVisibility && (visibleObjects = CollectionUtils.copyOf(Lists.transform(visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy), ObjectAdapter.Functions.getObject()), this.method.getReturnType())) != null) {
            return visibleObjects;
        }
        return collectionOrArray;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

