/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.clear;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacetAbstract;

public class CollectionClearFacetViaClearMethod
extends CollectionClearFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public CollectionClearFacetViaClearMethod(Method method, FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.MODIFY_COLLECTION_ADD;
    }

    @Override
    public void clear(ObjectAdapter owningAdapter) {
        ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

