/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.layout;

import java.util.Properties;
import org.apache.isis.applib.annotation.CollectionLayout;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.defaultview.DefaultViewFacet;
import org.apache.isis.core.metamodel.facets.collections.layout.CssClassFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.CssClassFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.DefaultViewFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.DefaultViewFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.DescribedAsFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.DescribedAsFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.HiddenFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.HiddenFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.NamedFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.NamedFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.PagedFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.PagedFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.RenderFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.RenderFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.layout.SortedByFacetForCollectionLayoutAnnotation;
import org.apache.isis.core.metamodel.facets.collections.layout.SortedByFacetOnCollectionFromLayoutProperties;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.facets.object.paged.PagedFacet;

public class CollectionLayoutFacetFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    public CollectionLayoutFacetFactory() {
        super(FeatureType.COLLECTIONS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Object holder = processMethodContext.getFacetHolder();
        Properties properties = processMethodContext.metadataProperties("collectionLayout");
        if (properties == null) {
            properties = processMethodContext.metadataProperties("layout");
        }
        CollectionLayout collectionLayout = Annotations.getAnnotation(processMethodContext.getMethod(), CollectionLayout.class);
        CssClassFacet cssClassFacet = CssClassFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (cssClassFacet == null) {
            cssClassFacet = CssClassFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(cssClassFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (describedAsFacet == null) {
            describedAsFacet = DescribedAsFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (hiddenFacet == null) {
            hiddenFacet = HiddenFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(hiddenFacet);
        DefaultViewFacet defaultViewFacet = DefaultViewFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (defaultViewFacet == null) {
            defaultViewFacet = DefaultViewFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(defaultViewFacet);
        NamedFacet namedFacet = NamedFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (namedFacet == null) {
            namedFacet = NamedFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(namedFacet);
        PagedFacet pagedFacet = PagedFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (pagedFacet == null) {
            pagedFacet = PagedFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(pagedFacet);
        RenderFacet renderFacet = RenderFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (renderFacet == null) {
            renderFacet = RenderFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(renderFacet);
        SortedByFacet sortedByFacet = SortedByFacetOnCollectionFromLayoutProperties.create(properties, holder);
        if (sortedByFacet == null) {
            sortedByFacet = SortedByFacetForCollectionLayoutAnnotation.create(collectionLayout, holder);
        }
        FacetUtil.addFacet(sortedByFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        Object holder = processMemberContext.getFacetHolder();
        Properties properties = processMemberContext.metadataProperties("collectionLayout");
        if (properties == null) {
            properties = processMemberContext.metadataProperties("layout");
        }
        CssClassFacet cssClassFacet = CssClassFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(cssClassFacet);
        DescribedAsFacet describedAsFacet = DescribedAsFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(describedAsFacet);
        HiddenFacet hiddenFacet = HiddenFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(hiddenFacet);
        NamedFacet namedFacet = NamedFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(namedFacet);
        PagedFacet pagedFacet = PagedFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(pagedFacet);
        RenderFacet renderFacet = RenderFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(renderFacet);
        SortedByFacet sortedByFacet = SortedByFacetOnCollectionFromLayoutProperties.create(properties, holder);
        FacetUtil.addFacet(sortedByFacet);
    }
}

