/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.sortedby.annotation;

import java.util.Comparator;
import java.util.List;
import org.apache.isis.applib.annotation.SortedBy;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.collections.sortedby.SortedByFacet;
import org.apache.isis.core.metamodel.facets.collections.sortedby.annotation.SortedByFacetAnnotation;
import org.apache.isis.core.metamodel.progmodel.DeprecatedMarker;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

@Deprecated
public class SortedByFacetAnnotationFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
DeprecatedMarker {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(SortedBy.class);

    public SortedByFacetAnnotationFactory() {
        super(FeatureType.COLLECTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        SortedBy renderAnnotation = Annotations.getAnnotation(processMethodContext.getMethod(), SortedBy.class);
        SortedByFacet facet = this.create(renderAnnotation, (FacetHolder)processMethodContext.getFacetHolder());
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private SortedByFacet create(SortedBy annotation, FacetHolder holder) {
        Class annotationValue;
        if (annotation == null) {
            return null;
        }
        Class comparatorType = annotationValue = annotation.value();
        return new SortedByFacetAnnotation(holder, comparatorType);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(this.newValidatorVisitor()));
        metaModelValidator.add(this.validator);
    }

    protected MetaModelValidatorVisiting.Visitor newValidatorVisitor() {
        return new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                List<OneToManyAssociation> objectCollections = objectSpec.getCollections(Contributed.EXCLUDED);
                for (OneToManyAssociation objectCollection : objectCollections) {
                    Class cls;
                    SortedByFacet facet = objectCollection.getFacet(SortedByFacet.class);
                    if (facet == null || Comparator.class.isAssignableFrom(cls = (Class)facet.value())) continue;
                    validationFailures.add("%s#%s: is annotated with @SortedBy, but the class specified '%s' is not a Comparator", objectSpec.getIdentifier().getClassName(), objectCollection.getId(), ((Class)facet.value()).getName());
                }
                return true;
            }
        };
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.validator.setConfiguration(servicesInjector.lookupService(ConfigurationServiceInternal.class));
    }
}

