/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.validate;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacetAbstract;

public class CollectionValidateRemoveFromFacetViaMethod
extends CollectionValidateRemoveFromFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final TranslationService translationService;
    private final String translationContext;

    public CollectionValidateRemoveFromFacetViaMethod(Method method, TranslationService translationService, String translationContext, FacetHolder holder) {
        super(holder);
        this.method = method;
        this.translationService = translationService;
        this.translationContext = translationContext;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_VALID;
    }

    @Override
    public String invalidReason(ObjectAdapter owningAdapter, ObjectAdapter proposedAdapter) {
        Object returnValue = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, proposedAdapter);
        if (returnValue instanceof String) {
            return (String)returnValue;
        }
        if (returnValue instanceof TranslatableString) {
            TranslatableString ts = (TranslatableString)returnValue;
            return ts.translate(this.translationService, this.translationContext);
        }
        return null;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

