/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.cssclass.annotprop;

import java.util.Properties;
import org.apache.isis.applib.annotation.CssClass;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.annotprop.CssClassFacetOnMemberAnnotation;
import org.apache.isis.core.metamodel.facets.members.cssclass.annotprop.CssClassFacetOnMemberFromProperties;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class CssClassFacetOnMemberFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(CssClass.class);

    public CssClassFacetOnMemberFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        CssClassFacet cssClassFacet = CssClassFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (cssClassFacet == null) {
            cssClassFacet = this.validator.flagIfPresent(this.createFromAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        FacetUtil.addFacet(cssClassFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        CssClassFacet cssClassFacet = CssClassFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(cssClassFacet);
    }

    private static CssClassFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("cssClass");
        return properties != null ? new CssClassFacetOnMemberFromProperties(properties, holder) : null;
    }

    private CssClassFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        CssClass annotation = Annotations.getAnnotation(processMethodContext.getMethod(), CssClass.class);
        return annotation != null ? new CssClassFacetOnMemberAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        IsisConfiguration configuration = this.getConfiguration();
        this.validator.setConfiguration(configuration);
    }
}

