/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.describedas.annotprop;

import java.util.Properties;
import org.apache.isis.applib.annotation.DescribedAs;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.all.describedas.DescribedAsFacet;
import org.apache.isis.core.metamodel.facets.members.describedas.annotprop.DescribedAsFacetOnMemberAnnotation;
import org.apache.isis.core.metamodel.facets.members.describedas.annotprop.DescribedAsFacetOnMemberDerivedFromType;
import org.apache.isis.core.metamodel.facets.members.describedas.annotprop.DescribedAsFacetOnMemberFromProperties;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;

public class DescribedAsFacetOnMemberFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory,
MetaModelValidatorRefiner {
    private final MetaModelValidatorForDeprecatedAnnotation validator = new MetaModelValidatorForDeprecatedAnnotation(DescribedAs.class);

    public DescribedAsFacetOnMemberFactory() {
        super(FeatureType.MEMBERS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DescribedAsFacet facet = DescribedAsFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMethodContext);
        if (facet == null) {
            facet = this.validator.flagIfPresent(DescribedAsFacetOnMemberFactory.createFromAnnotationIfPossible(processMethodContext), processMethodContext);
        }
        if (facet == null) {
            facet = this.createFromAnnotationOnReturnTypeIfPossible(processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        DescribedAsFacet facet = DescribedAsFacetOnMemberFactory.createFromMetadataPropertiesIfPossible(processMemberContext);
        FacetUtil.addFacet(facet);
    }

    private static DescribedAsFacet createFromMetadataPropertiesIfPossible(FacetFactory.ProcessContextWithMetadataProperties<? extends FacetHolder> pcwmp) {
        FacetHolder holder = pcwmp.getFacetHolder();
        Properties properties = pcwmp.metadataProperties("describedAs");
        return properties != null ? new DescribedAsFacetOnMemberFromProperties(properties, holder) : null;
    }

    private static DescribedAsFacet createFromAnnotationIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        DescribedAs annotation = Annotations.getAnnotation(processMethodContext.getMethod(), DescribedAs.class);
        return annotation == null ? null : new DescribedAsFacetOnMemberAnnotation(annotation.value(), (FacetHolder)processMethodContext.getFacetHolder());
    }

    private DescribedAsFacet createFromAnnotationOnReturnTypeIfPossible(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        DescribedAsFacet returnTypeDescribedAsFacet = this.getDescribedAsFacet(returnType);
        return returnTypeDescribedAsFacet != null ? new DescribedAsFacetOnMemberDerivedFromType(returnTypeDescribedAsFacet, (FacetHolder)processMethodContext.getFacetHolder()) : null;
    }

    private DescribedAsFacet getDescribedAsFacet(Class<?> type) {
        ObjectSpecification paramTypeSpec = this.getSpecificationLoader().loadSpecification(type);
        return paramTypeSpec.getFacet(DescribedAsFacet.class);
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        ConfigurationServiceInternal configuration = servicesInjector.getConfigurationServiceInternal();
        this.validator.setConfiguration(configuration);
    }
}

