/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.describedas.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.members.describedas.staticmethod.DescribedAsFacetStaticMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class DescribedAsFacetStaticMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private static final String[] PREFIXES = new String[]{"description"};
    private final MetaModelValidatorForDeprecatedMethodPrefix validator = new MetaModelValidatorForDeprecatedMethodPrefix(PREFIXES[0]);

    public DescribedAsFacetStaticMethodFactory() {
        super(FeatureType.MEMBERS, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachDescribedAsFacetIfDescriptionMethodIsFound(processMethodContext);
    }

    public void attachDescribedAsFacetIfDescriptionMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseNameStripAccessorPrefixIfRequired(method.getName());
        Class<?> cls = processMethodContext.getCls();
        Method descriptionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "description" + capitalizedName, String.class, new Class[0]);
        if (descriptionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(descriptionMethod);
        String description = DescribedAsFacetStaticMethodFactory.invokeDescriptionMethod(descriptionMethod);
        Object facetedMethod = processMethodContext.getFacetHolder();
        DescribedAsFacetStaticMethod facet = new DescribedAsFacetStaticMethod(description, descriptionMethod, (FacetHolder)facetedMethod);
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private static String invokeDescriptionMethod(Method descriptionMethod) {
        String description = null;
        try {
            description = (String)MethodExtensions.invokeStatic(descriptionMethod);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (description == null) {
            throw new MetaModelException("method " + descriptionMethod + "must return a string");
        }
        return description;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        ConfigurationServiceInternal configuration = servicesInjector.getConfigurationServiceInternal();
        this.validator.setConfiguration(configuration);
    }
}

