/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.disabled.forsession;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.forsession.DisableForSessionFacetAbstract;

public class DisableForSessionFacetViaMethod
extends DisableForSessionFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public DisableForSessionFacetViaMethod(Method method, FacetHolder holder, AuthenticationSessionProvider authenticationSessionProvider) {
        super(holder, authenticationSessionProvider);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHECK_IF_DISABLED;
    }

    @Override
    public String disabledReason(AuthenticationSession session) {
        if (session == null) {
            return null;
        }
        int len = this.method.getParameterTypes().length;
        Object[] parameters = new Object[len];
        parameters[0] = session.createUserMemento();
        return (String)MethodExtensions.invokeStatic(this.method, parameters);
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }
}

