/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class CreatedCallbackFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"created"};

    public CreatedCallbackFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object holder = processClassContext.getFacetHolder();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        ArrayList<Method> methods = new ArrayList<Method>();
        Method method = null;
        method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "created", Void.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            methods.add(method);
            facets.add(new CreatedCallbackFacetViaMethod(method, (FacetHolder)holder));
        }
        processClassContext.removeMethods(methods);
        FacetUtil.addFacets(facets);
    }
}

