/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class PersistCallbackFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"persisted", "persisting"};

    public PersistCallbackFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        CallbackFacet facet;
        Class<?> cls = processClassContext.getCls();
        CallbackFacet facetHolder = processClassContext.getFacetHolder();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        ArrayList<Method> methods = new ArrayList<Method>();
        Method method = null;
        method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "persisting", Void.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            methods.add(method);
            facet = facetHolder.getFacet(PersistingCallbackFacet.class);
            if (facet == null) {
                facets.add(new PersistingCallbackFacetViaMethod(method, (FacetHolder)((Object)facetHolder)));
            } else {
                facet.addMethod(method);
            }
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "persisted", Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            methods.add(method);
            facet = facetHolder.getFacet(PersistedCallbackFacet.class);
            if (facet == null) {
                facets.add(new PersistedCallbackFacetViaMethod(method, (FacetHolder)((Object)facetHolder)));
            } else {
                facet.addMethod(method);
            }
        }
        processClassContext.removeMethods(methods);
        FacetUtil.addFacets(facets);
    }
}

