/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.callbacks.CallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovedCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingCallbackFacetViaMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class RemoveCallbackViaDeleteMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"deleted", "deleting"};

    public RemoveCallbackViaDeleteMethodFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        CallbackFacet facet;
        Class<?> cls = processClassContext.getCls();
        CallbackFacet holder = processClassContext.getFacetHolder();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        ArrayList<Method> methods = new ArrayList<Method>();
        Method method = null;
        method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "deleting", Void.TYPE, NO_PARAMETERS_TYPES);
        if (method != null) {
            methods.add(method);
            facet = holder.getFacet(RemovingCallbackFacet.class);
            if (facet == null) {
                facets.add(new RemovingCallbackFacetViaMethod(method, (FacetHolder)((Object)holder)));
            } else {
                facet.addMethod(method);
            }
        }
        if ((method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "deleted", Void.TYPE, NO_PARAMETERS_TYPES)) != null) {
            methods.add(method);
            facet = holder.getFacet(RemovedCallbackFacet.class);
            if (facet == null) {
                facets.add(new RemovedCallbackFacetViaMethod(method, (FacetHolder)((Object)holder)));
            } else {
                facet.addMethod(method);
            }
        }
        processClassContext.removeMethods(methods);
        FacetUtil.addFacets(facets);
    }
}

