/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.callbacks;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.Wormhole;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingCallbackFacetAbstract;

public class UpdatingCallbackFacetViaMethod
extends UpdatingCallbackFacetAbstract
implements ImperativeFacet {
    private final List<Method> methods = new ArrayList<Method>();

    public UpdatingCallbackFacetViaMethod(Method method, FacetHolder holder) {
        super(holder);
        this.addMethod(method);
    }

    @Override
    public void addMethod(Method method) {
        this.methods.add(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.unmodifiableList(this.methods);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.LIFECYCLE;
    }

    @Override
    public void invoke(final ObjectAdapter adapter) {
        Wormhole.invoke(new Runnable(){

            @Override
            public void run() {
                ObjectAdapter.InvokeUtils.invokeAll(UpdatingCallbackFacetViaMethod.this.methods, adapter);
            }
        });
    }

    @Override
    protected String toStringValues() {
        return "methods=" + this.methods;
    }
}

