/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.choices.enums;

import java.lang.reflect.Method;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.util.Enums;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.object.choices.enums.EnumFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class EnumValueSemanticsProvider<T extends Enum<T>>
extends ValueSemanticsProviderAndFacetAbstract<T>
implements EnumFacet {
    private static final String TITLE = "title";
    private final Method titleMethod = MethodFinderUtils.findMethod(this.getAdaptedClass(), MethodScope.OBJECT, "title", new Class[]{String.class, TranslatableString.class}, null);

    private static Class<? extends Facet> type() {
        return EnumFacet.class;
    }

    private static <T> T defaultFor(Class<T> adaptedClass) {
        return adaptedClass.getEnumConstants()[0];
    }

    private static <T extends Enum<T>> int maxLengthFor(Class<T> adaptedClass) {
        int max = Integer.MIN_VALUE;
        for (Enum e : (Enum[])adaptedClass.getEnumConstants()) {
            int nameLength = e.name().length();
            int toStringLength = e.toString().length();
            max = Math.max(max, Math.max(nameLength, toStringLength));
        }
        return max;
    }

    public EnumValueSemanticsProvider() {
        this((FacetHolder)null, (Class<T>)null, (ServicesInjector)null);
    }

    public EnumValueSemanticsProvider(FacetHolder holder, Class<T> adaptedClass, ServicesInjector context) {
        super(EnumValueSemanticsProvider.type(), holder, adaptedClass, EnumValueSemanticsProvider.maxLengthFor(adaptedClass), EnumValueSemanticsProvider.maxLengthFor(adaptedClass), ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, EnumValueSemanticsProvider.defaultFor(adaptedClass), context);
    }

    @Override
    protected T doParse(Object context, String entry) {
        Enum[] enumConstants;
        for (Enum enumConstant : enumConstants = (Enum[])this.getAdaptedClass().getEnumConstants()) {
            if (!this.doEncode(enumConstant).equals(entry)) continue;
            return (T)enumConstant;
        }
        for (Enum enumConstant : enumConstants) {
            if (!enumConstant.toString().equals(entry)) continue;
            return (T)enumConstant;
        }
        throw new TextEntryParseException("Unknown enum constant '" + entry + "'");
    }

    @Override
    protected String doEncode(Object object) {
        return this.titleString(object);
    }

    @Override
    protected T doRestore(String data) {
        return (T)this.doParse((Object)null, data);
    }

    @Override
    protected String titleString(Object object) {
        TranslationService translationService = this.getServicesInjector().lookupService(TranslationService.class);
        if (this.titleMethod != null) {
            String translationContext = this.titleMethod.getDeclaringClass().getName() + "#" + this.titleMethod.getName() + "()";
            try {
                Object returnValue = MethodExtensions.invoke(this.titleMethod, object);
                if (returnValue instanceof String) {
                    return (String)returnValue;
                }
                if (returnValue instanceof TranslatableString) {
                    TranslatableString ts = (TranslatableString)returnValue;
                    return ts.translate(translationService, translationContext);
                }
                return null;
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        Enum objectAsEnum = (Enum)object;
        String translationContext = object.getClass().getName() + "#" + objectAsEnum.name();
        String friendlyNameOfEnum = Enums.getFriendlyNameOf((String)objectAsEnum.name());
        return translationService.translate(translationContext, friendlyNameOfEnum);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value);
    }
}

