/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.cssclass.method;

import java.lang.reflect.Method;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.cssclass.method.CssClassFacetMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class CssClassFacetMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String CSS_CLASS_PREFIX = "cssClass";
    private static final String[] PREFIXES = new String[]{"cssClass"};

    public CssClassFacetMethodFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, CSS_CLASS_PREFIX, String.class, NO_PARAMETERS_TYPES);
        if (method == null) {
            return;
        }
        processClassContext.removeMethod(method);
        FacetUtil.addFacet(new CssClassFacetMethod(method, (FacetHolder)facetHolder));
    }
}

