/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.isis.applib.annotation.Audited;
import org.apache.isis.applib.annotation.AutoComplete;
import org.apache.isis.applib.annotation.Bounded;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Immutable;
import org.apache.isis.applib.annotation.ObjectType;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.HasTransactionId;
import org.apache.isis.applib.services.eventbus.ObjectCreatedEvent;
import org.apache.isis.applib.services.eventbus.ObjectLoadedEvent;
import org.apache.isis.applib.services.eventbus.ObjectPersistedEvent;
import org.apache.isis.applib.services.eventbus.ObjectPersistingEvent;
import org.apache.isis.applib.services.eventbus.ObjectRemovingEvent;
import org.apache.isis.applib.services.eventbus.ObjectUpdatedEvent;
import org.apache.isis.applib.services.eventbus.ObjectUpdatingEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.Nullable;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.object.callbacks.CreatedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.LoadedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.PersistingLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.RemovingLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatedLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.callbacks.UpdatingLifecycleEventFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForAuditedAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.autocomplete.AutoCompleteFacetForAutoCompleteAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.autocomplete.AutoCompleteFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.choices.ChoicesFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.choices.ChoicesFacetFromBoundedAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.editing.ImmutableFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetForJdoPersistenceCapableAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.objectspecid.ObjectSpecIdFacetFromObjectTypeAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.publishing.PublishedObjectFacetForPublishedObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.domainobject.recreatable.RecreatableObjectFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacet;
import org.apache.isis.core.metamodel.facets.object.immutable.immutableannot.ImmutableFacetForImmutableAnnotation;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacet;
import org.apache.isis.core.metamodel.facets.object.mixin.MixinFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.object.objectspecid.ObjectSpecIdFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedAnnotation;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForValidationFailures;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;
import org.apache.isis.core.metamodel.util.EventUtil;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

public class DomainObjectAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
PostConstructMethodCache {
    private final MetaModelValidatorForDeprecatedAnnotation auditedValidator = new MetaModelValidatorForDeprecatedAnnotation(Audited.class);
    private final MetaModelValidatorForDeprecatedAnnotation publishedObjectValidator = new MetaModelValidatorForDeprecatedAnnotation(PublishedObject.class);
    private final MetaModelValidatorForDeprecatedAnnotation autoCompleteValidator = new MetaModelValidatorForDeprecatedAnnotation(AutoComplete.class);
    private final MetaModelValidatorForDeprecatedAnnotation boundedValidator = new MetaModelValidatorForDeprecatedAnnotation(Bounded.class);
    private final MetaModelValidatorForDeprecatedAnnotation immutableValidator = new MetaModelValidatorForDeprecatedAnnotation(Immutable.class);
    private final MetaModelValidatorForDeprecatedAnnotation objectTypeValidator = new MetaModelValidatorForDeprecatedAnnotation(ObjectType.class);
    private final MetaModelValidatorForValidationFailures autoCompleteInvalid = new MetaModelValidatorForValidationFailures();
    private final Map<Class, Nullable<Method>> postConstructMethods = Maps.newHashMap();
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    public DomainObjectAnnotationFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.processAuditing(processClassContext);
        this.processPublishing(processClassContext);
        this.processAutoComplete(processClassContext);
        this.processBounded(processClassContext);
        this.processEditing(processClassContext);
        this.processObjectType(processClassContext);
        this.processNature(processClassContext);
        this.processLifecycleEvents(processClassContext);
    }

    void processAuditing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object holder = processClassContext.getFacetHolder();
        if (HasTransactionId.class.isAssignableFrom(cls)) {
            return;
        }
        Audited annotation = Annotations.getAnnotation(cls, Audited.class);
        AuditableFacet auditableFacet = this.auditedValidator.flagIfPresent(AuditableFacetForAuditedAnnotation.create(annotation, holder), null);
        if (auditableFacet == null) {
            auditableFacet = AuditableFacetForDomainObjectAnnotation.create(domainObject, this.getConfiguration(), holder);
        }
        FacetUtil.addFacet(auditableFacet);
    }

    void processPublishing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        if (HasTransactionId.class.isAssignableFrom(cls)) {
            return;
        }
        PublishedObject publishedObject = Annotations.getAnnotation(processClassContext.getCls(), PublishedObject.class);
        PublishedObjectFacet publishedObjectFacet = this.publishedObjectValidator.flagIfPresent(PublishedObjectFacetForPublishedObjectAnnotation.create(publishedObject, facetHolder));
        if (publishedObjectFacet == null) {
            publishedObjectFacet = PublishedObjectFacetForDomainObjectAnnotation.create(domainObject, this.getConfiguration(), facetHolder);
        }
        FacetUtil.addFacet(publishedObjectFacet);
    }

    void processAutoComplete(FacetFactory.ProcessClassContext processClassContext) {
        AutoComplete autoCompleteAnnot;
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        AutoCompleteFacet facet = this.autoCompleteValidator.flagIfPresent(this.createFor((FacetHolder)facetHolder, autoCompleteAnnot = Annotations.getAnnotation(cls, AutoComplete.class), cls));
        if (facet == null) {
            DomainObject domainObjectAnnot = Annotations.getAnnotation(cls, DomainObject.class);
            facet = this.createFor(domainObjectAnnot, (FacetHolder)facetHolder, cls);
        }
        FacetUtil.addFacet(facet);
    }

    private AutoCompleteFacet createFor(FacetHolder facetHolder, AutoComplete annotation, Class<?> cls) {
        if (annotation == null) {
            return null;
        }
        Class repositoryClass = annotation.repository();
        String actionName = annotation.action();
        if (!this.isServiceType(cls, "@AutoComplete", repositoryClass)) {
            return null;
        }
        Method repositoryMethod = this.findRepositoryMethod(cls, "@AutoComplete", repositoryClass, actionName);
        if (repositoryMethod == null) {
            return null;
        }
        return new AutoCompleteFacetForAutoCompleteAnnotation(facetHolder, repositoryClass, repositoryMethod, this.servicesInjector);
    }

    private AutoCompleteFacet createFor(DomainObject domainObject, FacetHolder facetHolder, Class<?> cls) {
        if (domainObject == null) {
            return null;
        }
        Class repositoryClass = domainObject.autoCompleteRepository();
        if (repositoryClass == null || repositoryClass == Object.class) {
            return null;
        }
        String actionName = domainObject.autoCompleteAction();
        if (!this.isServiceType(cls, "@DomainObject", repositoryClass)) {
            return null;
        }
        Method repositoryMethod = this.findRepositoryMethod(cls, "@DomainObject", repositoryClass, actionName);
        if (repositoryMethod == null) {
            return null;
        }
        return new AutoCompleteFacetForDomainObjectAnnotation(facetHolder, repositoryClass, repositoryMethod, this.servicesInjector);
    }

    private boolean isServiceType(Class<?> cls, String annotationName, Class<?> repositoryClass) {
        boolean isRegistered = this.servicesInjector.isRegisteredService(repositoryClass);
        if (!isRegistered) {
            this.autoCompleteInvalid.addFailure("%s annotation on %s specifies unknown repository '%s'", annotationName, cls.getName(), repositoryClass.getName());
        }
        return isRegistered;
    }

    private Method findRepositoryMethod(Class<?> cls, String annotationName, Class<?> repositoryClass, String methodName) {
        Method[] methods;
        for (Method method : methods = repositoryClass.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].equals(String.class)) continue;
            return method;
        }
        this.autoCompleteInvalid.addFailure("%s annotation on %s specifies action '%s' that does not exist in repository '%s'", annotationName, cls.getName(), methodName, repositoryClass.getName());
        return null;
    }

    void processBounded(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        Bounded annotation = Annotations.getAnnotation(processClassContext.getCls(), Bounded.class);
        Facet facet = this.boundedValidator.flagIfPresent(ChoicesFacetFromBoundedAnnotation.create(annotation, processClassContext.getFacetHolder(), this.getDeploymentCategory(), this.getAuthenticationSessionProvider(), this.persistenceSessionServiceInternal));
        if (facet == null) {
            facet = ChoicesFacetForDomainObjectAnnotation.create(domainObject, facetHolder, this.getDeploymentCategory(), this.getAuthenticationSessionProvider(), this.persistenceSessionServiceInternal);
        }
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        Immutable annotation = Annotations.getAnnotation(processClassContext.getCls(), Immutable.class);
        ImmutableFacet facet = this.immutableValidator.flagIfPresent(ImmutableFacetForImmutableAnnotation.create(annotation, processClassContext.getFacetHolder()));
        if (facet == null) {
            facet = ImmutableFacetForDomainObjectAnnotation.create(domainObject, this.getConfiguration(), facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processObjectType(FacetFactory.ProcessClassContext processClassContext) {
        JdoPersistenceCapableFacet jdoPersistenceCapableFacet;
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        JdoPersistenceCapableFacet facetHolder = processClassContext.getFacetHolder();
        ObjectType annotation = Annotations.getAnnotation(processClassContext.getCls(), ObjectType.class);
        ObjectSpecIdFacet facet = this.objectTypeValidator.flagIfPresent(ObjectSpecIdFacetFromObjectTypeAnnotation.create(annotation, processClassContext.getFacetHolder()));
        if (facet == null) {
            facet = ObjectSpecIdFacetForDomainObjectAnnotation.create(domainObject, facetHolder);
        }
        if (facet == null && (jdoPersistenceCapableFacet = facetHolder.getFacet(JdoPersistenceCapableFacet.class)) != null) {
            facet = ObjectSpecIdFacetForJdoPersistenceCapableAnnotation.create(jdoPersistenceCapableFacet, facetHolder);
        }
        FacetUtil.addFacet(facet);
    }

    void processNature(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        Object facetHolder = processClassContext.getFacetHolder();
        DomainObjectAnnotationFacetFactory postConstructMethodCache = this;
        ViewModelFacet recreatableObjectFacet = RecreatableObjectFacetForDomainObjectAnnotation.create(domainObject, this.getSpecificationLoader(), this.persistenceSessionServiceInternal, this.servicesInjector, facetHolder, postConstructMethodCache);
        FacetUtil.addFacet(recreatableObjectFacet);
        MixinFacet mixinFacet = MixinFacetForDomainObjectAnnotation.create(cls, facetHolder, this.servicesInjector);
        FacetUtil.addFacet(mixinFacet);
    }

    private void processLifecycleEvents(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        DomainObject domainObject = Annotations.getAnnotation(cls, DomainObject.class);
        if (domainObject == null) {
            return;
        }
        Object holder = processClassContext.getFacetHolder();
        this.processLifecycleEventCreated(domainObject, (FacetHolder)holder);
        this.processLifecycleEventLoaded(domainObject, (FacetHolder)holder);
        this.processLifecycleEventPersisted(domainObject, (FacetHolder)holder);
        this.processLifecycleEventPersisting(domainObject, (FacetHolder)holder);
        this.processLifecycleEventRemoving(domainObject, (FacetHolder)holder);
        this.processLifecycleEventUpdated(domainObject, (FacetHolder)holder);
        this.processLifecycleEventUpdating(domainObject, (FacetHolder)holder);
    }

    private void processLifecycleEventCreated(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.createdLifecycleEvent();
        CreatedLifecycleEventFacetForDomainObjectAnnotation facet = new CreatedLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectCreatedEvent.Noop.class, ObjectCreatedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.createdLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    private void processLifecycleEventLoaded(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.loadedLifecycleEvent();
        LoadedLifecycleEventFacetForDomainObjectAnnotation facet = new LoadedLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectLoadedEvent.Noop.class, ObjectLoadedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.loadedLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    private void processLifecycleEventPersisting(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.persistingLifecycleEvent();
        PersistingLifecycleEventFacetForDomainObjectAnnotation facet = new PersistingLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectPersistingEvent.Noop.class, ObjectPersistingEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.persistingLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    private void processLifecycleEventPersisted(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.persistedLifecycleEvent();
        PersistedLifecycleEventFacetForDomainObjectAnnotation facet = new PersistedLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectPersistedEvent.Noop.class, ObjectPersistedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.persistedLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    private void processLifecycleEventRemoving(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.removingLifecycleEvent();
        RemovingLifecycleEventFacetForDomainObjectAnnotation facet = new RemovingLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectRemovingEvent.Noop.class, ObjectRemovingEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.removingLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    private void processLifecycleEventUpdated(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.updatedLifecycleEvent();
        UpdatedLifecycleEventFacetForDomainObjectAnnotation facet = new UpdatedLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectUpdatedEvent.Noop.class, ObjectUpdatedEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.updatedLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    private void processLifecycleEventUpdating(DomainObject domainObject, FacetHolder holder) {
        Class lifecycleEvent = domainObject.updatingLifecycleEvent();
        UpdatingLifecycleEventFacetForDomainObjectAnnotation facet = new UpdatingLifecycleEventFacetForDomainObjectAnnotation(holder, lifecycleEvent, this.getSpecificationLoader());
        if (EventUtil.eventTypeIsPostable(facet.getEventType(), ObjectUpdatingEvent.Noop.class, ObjectUpdatingEvent.Default.class, "isis.reflector.facet.domainObjectAnnotation.updatingLifecycleEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(facet);
        }
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification thisSpec, ValidationFailures validationFailures) {
                HashMap specById = Maps.newHashMap();
                Collection<ObjectSpecification> allSpecifications = DomainObjectAnnotationFacetFactory.this.getSpecificationLoader().allSpecifications();
                for (ObjectSpecification otherSpec : allSpecifications) {
                    ObjectSpecification existingSpec;
                    ObjectSpecId objectSpecId;
                    if (thisSpec == otherSpec || (objectSpecId = otherSpec.getSpecId()) == null || (existingSpec = specById.put(objectSpecId, otherSpec)) == null) continue;
                    validationFailures.add("%s: cannot have two entities with same object type (@DomainObject(objectType=...) or @ObjectType); %s has same value (%s).", existingSpec.getFullIdentifier(), otherSpec.getFullIdentifier(), objectSpecId);
                }
                return true;
            }
        }));
        metaModelValidator.add(this.publishedObjectValidator);
        metaModelValidator.add(this.auditedValidator);
        metaModelValidator.add(this.autoCompleteValidator);
        metaModelValidator.add(this.boundedValidator);
        metaModelValidator.add(this.immutableValidator);
        metaModelValidator.add(this.objectTypeValidator);
        metaModelValidator.add(this.autoCompleteInvalid);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        IsisConfiguration configuration = this.getConfiguration();
        this.publishedObjectValidator.setConfiguration(configuration);
        this.auditedValidator.setConfiguration(configuration);
        this.autoCompleteValidator.setConfiguration(configuration);
        this.boundedValidator.setConfiguration(configuration);
        this.immutableValidator.setConfiguration(configuration);
        this.objectTypeValidator.setConfiguration(configuration);
        this.persistenceSessionServiceInternal = servicesInjector.getPersistenceSessionServiceInternal();
    }

    @Override
    public Method postConstructMethodFor(Object pojo) {
        return MethodFinderUtils.findAnnotatedMethod(pojo, PostConstruct.class, this.postConstructMethods);
    }
}

