/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.auditing;

import org.apache.isis.applib.annotation.Auditing;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacet;
import org.apache.isis.core.metamodel.facets.object.audit.AuditableFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditObjectsConfiguration;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetForDomainObjectAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.object.domainobject.auditing.AuditableFacetFromConfiguration;

public class AuditableFacetForDomainObjectAnnotation
extends AuditableFacetAbstract {
    public static AuditableFacet create(DomainObject domainObject, IsisConfiguration configuration, FacetHolder holder) {
        Auditing auditing = domainObject != null ? domainObject.auditing() : Auditing.AS_CONFIGURED;
        switch (auditing) {
            case AS_CONFIGURED: {
                AuditObjectsConfiguration setting = AuditObjectsConfiguration.parse(configuration);
                switch (setting) {
                    case NONE: {
                        return null;
                    }
                }
                return domainObject != null ? new AuditableFacetForDomainObjectAnnotationAsConfigured(holder) : new AuditableFacetFromConfiguration(holder);
            }
            case DISABLED: {
                return new AuditableFacetForDomainObjectAnnotation(AuditableFacetAbstract.Enablement.DISABLED, holder);
            }
            case ENABLED: {
                return new AuditableFacetForDomainObjectAnnotation(AuditableFacetAbstract.Enablement.ENABLED, holder);
            }
        }
        return null;
    }

    protected AuditableFacetForDomainObjectAnnotation(AuditableFacetAbstract.Enablement enablement, FacetHolder holder) {
        super(holder, enablement);
    }
}

