/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobject.recreatable;

import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetDeclarativeInitializingAbstract;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class RecreatableObjectFacetForDomainObjectAnnotation
extends RecreatableObjectFacetDeclarativeInitializingAbstract {
    public static ViewModelFacet create(DomainObject domainObject, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector, FacetHolder holder, PostConstructMethodCache postConstructMethodCache) {
        if (domainObject == null) {
            return null;
        }
        Nature nature = domainObject.nature();
        if (nature == null) {
            return null;
        }
        switch (nature) {
            case NOT_SPECIFIED: 
            case JDO_ENTITY: 
            case MIXIN: {
                return null;
            }
            case VIEW_MODEL: {
                ViewModelFacet existingFacet = holder.getFacet(ViewModelFacet.class);
                if (existingFacet != null && existingFacet.getArchitecturalLayer() == ViewModelFacet.ArchitecturalLayer.APPLICATION) {
                    return null;
                }
                return new RecreatableObjectFacetForDomainObjectAnnotation(holder, ViewModelFacet.ArchitecturalLayer.APPLICATION, specificationLoader, adapterManager, servicesInjector, postConstructMethodCache);
            }
            case EXTERNAL_ENTITY: 
            case INMEMORY_ENTITY: {
                return new RecreatableObjectFacetForDomainObjectAnnotation(holder, ViewModelFacet.ArchitecturalLayer.DOMAIN, specificationLoader, adapterManager, servicesInjector, postConstructMethodCache);
            }
        }
        throw new IllegalArgumentException("nature of '" + nature + "' not recognized");
    }

    private RecreatableObjectFacetForDomainObjectAnnotation(FacetHolder holder, ViewModelFacet.ArchitecturalLayer architecturalLayer, SpecificationLoader specificationLoader, AdapterManager adapterManager, ServicesInjector servicesInjector, PostConstructMethodCache postConstructMethodCache) {
        super(holder, architecturalLayer, ViewModelFacet.RecreationMechanism.INITIALIZES, specificationLoader, adapterManager, servicesInjector, postConstructMethodCache);
    }
}

