/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.eventbus.IconUiEvent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.icon.IconFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.util.EventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconFacetViaDomainObjectLayoutAnnotationUsingIconUiEvent
extends IconFacetAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(IconFacetViaDomainObjectLayoutAnnotationUsingIconUiEvent.class);
    private final Class<? extends IconUiEvent<?>> iconUiEventClass;
    private final EventBusService eventBusService;

    public static Facet create(DomainObjectLayout domainObjectLayout, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        if (domainObjectLayout == null) {
            return null;
        }
        Class iconUiEventClass = domainObjectLayout.iconUiEvent();
        if (!EventUtil.eventTypeIsPostable(iconUiEventClass, IconUiEvent.Noop.class, IconUiEvent.Default.class, "isis.reflector.facet.domainObjectLayoutAnnotation.iconUiEvent.postForDefault", configuration)) {
            return null;
        }
        EventBusService eventBusService = servicesInjector.lookupService(EventBusService.class);
        return new IconFacetViaDomainObjectLayoutAnnotationUsingIconUiEvent(iconUiEventClass, eventBusService, facetHolder);
    }

    public IconFacetViaDomainObjectLayoutAnnotationUsingIconUiEvent(Class<? extends IconUiEvent<?>> iconUiEventClass, EventBusService eventBusService, FacetHolder holder) {
        super(holder);
        this.iconUiEventClass = iconUiEventClass;
        this.eventBusService = eventBusService;
    }

    @Override
    public String iconName(ObjectAdapter owningAdapter) {
        IconUiEvent<Object> iconUiEvent = this.newIconUiEvent(owningAdapter);
        this.eventBusService.post(iconUiEvent);
        String iconName = iconUiEvent.getIconName();
        return iconName;
    }

    private IconUiEvent<Object> newIconUiEvent(ObjectAdapter owningAdapter) {
        Object domainObject = owningAdapter.getObject();
        return this.newIconUiEvent(domainObject);
    }

    private IconUiEvent<Object> newIconUiEvent(Object domainObject) {
        try {
            IconUiEvent<?> iconUiEvent = this.iconUiEventClass.newInstance();
            iconUiEvent.setSource(domainObject);
            return iconUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }
}

