/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.domainobjectlayout;

import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.services.eventbus.EventBusService;
import org.apache.isis.applib.services.eventbus.TitleUiEvent;
import org.apache.isis.applib.services.i18n.TranslatableString;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.util.EventUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent
extends TitleFacetAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent.class);
    private final Class<? extends TitleUiEvent<?>> titleUiEventClass;
    private final TranslationService translationService;
    private final String translationContext;
    private final EventBusService eventBusService;

    public static Facet create(DomainObjectLayout domainObjectLayout, ServicesInjector servicesInjector, IsisConfiguration configuration, FacetHolder facetHolder) {
        if (domainObjectLayout == null) {
            return null;
        }
        Class titleUiEventClass = domainObjectLayout.titleUiEvent();
        if (!EventUtil.eventTypeIsPostable(titleUiEventClass, TitleUiEvent.Noop.class, TitleUiEvent.Default.class, "isis.reflector.facet.domainObjectLayoutAnnotation.titleUiEvent.postForDefault", configuration)) {
            return null;
        }
        TranslationService translationService = servicesInjector.lookupService(TranslationService.class);
        ObjectSpecification facetHolderAsSpec = (ObjectSpecification)facetHolder;
        String translationContext = facetHolderAsSpec.getCorrespondingClass().getCanonicalName();
        EventBusService eventBusService = servicesInjector.lookupService(EventBusService.class);
        return new TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent(titleUiEventClass, translationService, translationContext, eventBusService, facetHolder);
    }

    public TitleFacetViaDomainObjectLayoutAnnotationUsingTitleUiEvent(Class<? extends TitleUiEvent<?>> titleUiEventClass, TranslationService translationService, String translationContext, EventBusService eventBusService, FacetHolder holder) {
        super(holder);
        this.titleUiEventClass = titleUiEventClass;
        this.translationService = translationService;
        this.translationContext = translationContext;
        this.eventBusService = eventBusService;
    }

    @Override
    public String title(ObjectAdapter owningAdapter) {
        TitleUiEvent<Object> titleUiEvent = this.newTitleUiEvent(owningAdapter);
        this.eventBusService.post(titleUiEvent);
        TranslatableString translatedTitle = titleUiEvent.getTranslatableTitle();
        if (translatedTitle != null) {
            return translatedTitle.translate(this.translationService, this.translationContext);
        }
        String title = titleUiEvent.getTitle();
        return title;
    }

    private TitleUiEvent<Object> newTitleUiEvent(ObjectAdapter owningAdapter) {
        Object domainObject = owningAdapter.getObject();
        return this.newTitleUiEvent(domainObject);
    }

    private TitleUiEvent<Object> newTitleUiEvent(Object domainObject) {
        try {
            TitleUiEvent<?> titleUiEvent = this.titleUiEventClass.newInstance();
            titleUiEvent.setSource(domainObject);
            return titleUiEvent;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new NonRecoverableException((Throwable)ex);
        }
    }
}

