/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.icon.method;

import java.lang.reflect.Method;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.object.icon.method.IconFacetMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public class IconFacetMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String ICON_NAME_PREFIX = "iconName";
    private static final String[] PREFIXES = new String[]{"iconName"};

    public IconFacetMethodFactory() {
        super(FeatureType.OBJECTS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class<?> cls = processClassContext.getCls();
        Object facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, ICON_NAME_PREFIX, String.class, NO_PARAMETERS_TYPES);
        if (method == null) {
            return;
        }
        processClassContext.removeMethod(method);
        FacetUtil.addFacet(new IconFacetMethod(method, (FacetHolder)facetHolder));
    }
}

