/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.ignore.annotation;

import com.google.common.eventbus.Subscribe;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.isis.applib.annotation.Ignore;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;

public class RemoveAnnotatedMethodsFacetFactory
extends FacetFactoryAbstract {
    private Class<? extends Annotation> eventHandlerClass;

    public RemoveAnnotatedMethodsFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
        try {
            Class<?> cls = ClassUtil.forName("org.axonframework.eventhandling.annotation.EventHandler");
            this.eventHandlerClass = cls;
        }
        catch (Exception ignore) {
            this.eventHandlerClass = null;
        }
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        this.removeIgnoredMethods(processClassContext.getCls(), processClassContext);
    }

    private void removeIgnoredMethods(Class<?> cls, MethodRemover methodRemover) {
        Method[] methods;
        if (cls == null) {
            return;
        }
        for (Method method : methods = cls.getMethods()) {
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, PreDestroy.class);
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, PostConstruct.class);
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, Ignore.class);
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, Programmatic.class);
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, Subscribe.class);
            if (this.eventHandlerClass == null) continue;
            RemoveAnnotatedMethodsFacetFactory.removeAnnotatedMethods(methodRemover, method, this.eventHandlerClass);
        }
    }

    private static <T extends Annotation> void removeAnnotatedMethods(MethodRemover methodRemover, Method method, Class<T> annotationClass) {
        if (!Annotations.isAnnotationPresent(method, annotationClass)) {
            return;
        }
        methodRemover.removeMethod(method);
    }
}

