/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.mask;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MaskEvaluator {
    private static List<Converter> converters = new ArrayList<Converter>(){
        {
            this.add("#", "[0-9]");
            this.add("&", "[A-Za-z]");
            this.add("?", "[A-Za-z]");
            this.add("A", "[A-Za-z0-9]");
            this.add("a", "[ A-Za-z0-9]");
            this.add("9", "[ 0-9]");
            this.add("U", "[A-Z]");
            this.add("L", "[a-z]");
            this.add(new Converter(){

                @Override
                public void convert(String str, StringBuilder buf) {
                    if (buf.length() == 0) {
                        buf.append(str);
                    }
                }
            });
        }

        public void add(String mask, String regex) {
            this.add(new RegExConverter(mask, regex));
        }
    };
    private final Pattern pattern;

    public MaskEvaluator(String mask) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < mask.length(); ++i) {
            String charAt = "" + mask.charAt(i);
            for (Converter converter : converters) {
                converter.convert(charAt, buf);
            }
        }
        this.pattern = Pattern.compile(buf.toString());
    }

    public boolean evaluate(String str) {
        return this.pattern.matcher(str).matches();
    }

    static class RegExConverter
    implements Converter {
        private final String mask;
        private final String regex;

        public RegExConverter(String mask, String regex) {
            this.mask = mask;
            this.regex = regex;
        }

        public String getMask() {
            return this.mask;
        }

        public String getRegex() {
            return this.regex;
        }

        @Override
        public void convert(String str, StringBuilder buf) {
            String convert = str.replace(this.mask, this.regex);
            if (!convert.equals(str)) {
                buf.append(convert);
            }
        }
    }

    static interface Converter {
        public void convert(String var1, StringBuilder var2);
    }
}

