/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.facets.object.parseable.ParserUtil;
import org.apache.isis.core.metamodel.facets.object.parseable.parser.ParseableFacetUsingParser;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class ParseableFacetAbstract
extends FacetAbstract
implements ParseableFacet {
    private final Class<?> parserClass;
    private final ParseableFacetUsingParser parseableFacetUsingParser;

    public ParseableFacetAbstract(String candidateParserName, Class<?> candidateParserClass, FacetHolder holder, ServicesInjector servicesInjector) {
        super(ParseableFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.parserClass = ParserUtil.parserOrNull(candidateParserClass, candidateParserName);
        this.parseableFacetUsingParser = this.isValid() ? this.createParser(holder, servicesInjector) : null;
    }

    private ParseableFacetUsingParser createParser(FacetHolder holder, ServicesInjector servicesInjector) {
        Parser parser = (Parser)ClassExtensions.newInstance(this.parserClass, FacetHolder.class, holder);
        return new ParseableFacetUsingParser(parser, holder, servicesInjector);
    }

    public boolean isValid() {
        return this.parserClass != null;
    }

    public Class<?> getParserClass() {
        return this.parserClass;
    }

    @Override
    protected String toStringValues() {
        return this.parserClass.getName();
    }

    @Override
    public ObjectAdapter parseTextEntry(ObjectAdapter original, String entryText, InteractionInitiatedBy interactionInitiatedBy) {
        return this.parseableFacetUsingParser.parseTextEntry(original, entryText, interactionInitiatedBy);
    }

    @Override
    public String parseableTitle(ObjectAdapter existing) {
        return this.parseableFacetUsingParser.parseableTitle(existing);
    }
}

