/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.parseable.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Parseable;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.parseable.ParserUtil;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class ParseableFacetAnnotation
extends ParseableFacetAbstract {
    private static String parserName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Parseable annotation = annotatedClass.getAnnotation(Parseable.class);
        String parserName = annotation.parserName();
        if (!Strings.isNullOrEmpty((String)parserName)) {
            return parserName;
        }
        return ParserUtil.parserNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> parserClass(Class<?> annotatedClass) {
        Parseable annotation = annotatedClass.getAnnotation(Parseable.class);
        return annotation.parserClass();
    }

    public ParseableFacetAnnotation(Class<?> annotatedClass, IsisConfiguration configuration, FacetHolder holder, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        this(ParseableFacetAnnotation.parserName(annotatedClass, configuration), ParseableFacetAnnotation.parserClass(annotatedClass), holder, adapterManager, dependencyInjector);
    }

    private ParseableFacetAnnotation(String candidateParserName, Class<?> candidateParserClass, FacetHolder holder, AdapterManager adapterManager, ServicesInjector dependencyInjector) {
        super(candidateParserName, candidateParserClass, holder, dependencyInjector);
    }
}

