/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.recreatable;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.isis.applib.RecreatableDomainObject;
import org.apache.isis.applib.annotation.ViewModel;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.Nullable;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForRecreatableDomainObjectInterface;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForRecreatableObjectInterface;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForViewModelAnnotation;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetForXmlRootElementAnnotation;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class RecreatableObjectFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner,
PostConstructMethodCache {
    private final Map<Class, Nullable<Method>> postConstructMethods = Maps.newHashMap();
    PersistenceSessionServiceInternal adapterManager;

    public RecreatableObjectFacetFactory() {
        super(FeatureType.OBJECTS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        if (org.apache.isis.applib.ViewModel.class.isAssignableFrom(processClassContext.getCls())) {
            RecreatableObjectFacetFactory postConstructMethodCache = this;
            FacetUtil.addFacet(new RecreatableObjectFacetForRecreatableObjectInterface((FacetHolder)processClassContext.getFacetHolder(), postConstructMethodCache, this.servicesInjector));
        }
        ViewModel annotation = Annotations.getAnnotation(processClassContext.getCls(), ViewModel.class);
        FacetUtil.addFacet(this.create(annotation, (FacetHolder)processClassContext.getFacetHolder()));
        XmlRootElement xmlRootElement = Annotations.getAnnotation(processClassContext.getCls(), XmlRootElement.class);
        FacetUtil.addFacet(this.create(xmlRootElement, (FacetHolder)processClassContext.getFacetHolder()));
        if (RecreatableDomainObject.class.isAssignableFrom(processClassContext.getCls())) {
            RecreatableObjectFacetFactory postConstructMethodCache = this;
            FacetUtil.addFacet(new RecreatableObjectFacetForRecreatableDomainObjectInterface((FacetHolder)processClassContext.getFacetHolder(), postConstructMethodCache, this.servicesInjector));
        }
    }

    private ViewModelFacet create(ViewModel annotation, FacetHolder holder) {
        RecreatableObjectFacetFactory postConstructMethodCache = this;
        return annotation != null ? new RecreatableObjectFacetForViewModelAnnotation(holder, this.getSpecificationLoader(), this.adapterManager, this.servicesInjector, postConstructMethodCache) : null;
    }

    private ViewModelFacet create(XmlRootElement annotation, FacetHolder holder) {
        RecreatableObjectFacetFactory postConstructMethodCache = this;
        return annotation != null ? new RecreatableObjectFacetForXmlRootElementAnnotation(holder, this.servicesInjector, postConstructMethodCache) : null;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                Facet underlyingFacet;
                ViewModelFacet facet = objectSpec.getFacet(ViewModelFacet.class);
                Facet facet2 = underlyingFacet = facet != null ? facet.getUnderlyingFacet() : null;
                if (underlyingFacet != null) {
                    validationFailures.add("%s: has multiple incompatible annotations/interfaces indicating that it is a recreatable object of some sort (%s and %s)", objectSpec.getFullIdentifier(), facet.getClass().getSimpleName(), underlyingFacet.getClass().getSimpleName());
                }
                return true;
            }
        }));
    }

    @Override
    public Method postConstructMethodFor(Object pojo) {
        return MethodFinderUtils.findAnnotatedMethod(pojo, PostConstruct.class, this.postConstructMethods);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

