/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.recreatable;

import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.urlencoding.UrlEncodingService;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.PostConstructMethodCache;
import org.apache.isis.core.metamodel.facets.object.recreatable.RecreatableObjectFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class RecreatableObjectFacetForXmlRootElementAnnotation
extends RecreatableObjectFacetAbstract {
    public RecreatableObjectFacetForXmlRootElementAnnotation(FacetHolder holder, ServicesInjector servicesInjector, PostConstructMethodCache postConstructMethodCache) {
        super(holder, ViewModelFacet.ArchitecturalLayer.APPLICATION, ViewModelFacet.RecreationMechanism.INSTANTIATES, postConstructMethodCache, servicesInjector);
    }

    @Override
    protected Object doInstantiate(Class<?> viewModelClass, String mementoStr) {
        String xmlStr = this.getUrlEncodingService().decode(mementoStr);
        Object viewModelPojo = this.getJaxbService().fromXml(viewModelClass, xmlStr);
        return viewModelPojo;
    }

    @Override
    public String memento(Object pojo) {
        String xml = this.getJaxbService().toXml(pojo);
        String encoded = this.getUrlEncodingService().encode(xml);
        return encoded;
    }

    @Override
    public boolean isCloneable(Object pojo) {
        return true;
    }

    @Override
    public Object clone(Object pojo) {
        String xml = this.getJaxbService().toXml(pojo);
        Object cloned = this.getJaxbService().fromXml(pojo.getClass(), xml);
        return cloned;
    }

    private JaxbService getJaxbService() {
        return this.servicesInjector.lookupService(JaxbService.class);
    }

    private UrlEncodingService getUrlEncodingService() {
        return this.servicesInjector.lookupService(UrlEncodingService.class);
    }
}

