/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.title.annotation;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacetAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleFacetViaTitleAnnotation
extends TitleFacetAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(TitleFacetViaTitleAnnotation.class);
    private final List<TitleComponent> components;
    private final AdapterManager adapterManager;

    public TitleFacetViaTitleAnnotation(List<TitleComponent> components, FacetHolder holder, AdapterManager adapterManager) {
        super(holder);
        this.components = components;
        this.adapterManager = adapterManager;
    }

    @Override
    public String title(ObjectAdapter targetAdapter) {
        return this.title(null, targetAdapter);
    }

    private String titleOf(ObjectAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        return adapter.titleString(null);
    }

    public List<TitleComponent> getComponents() {
        return this.components;
    }

    private static String abbreviated(String str, int maxLength) {
        return str.length() < maxLength ? str : str.substring(0, maxLength - 3) + "...";
    }

    @Override
    public String title(ObjectAdapter contextAdapter, ObjectAdapter targetAdapter) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (TitleComponent component : this.components) {
                ObjectAdapter titlePartAdapter;
                Object titlePart = component.getTitleEvaluator().value(targetAdapter.getObject());
                if (titlePart == null || Objects.equal((Object)contextAdapter, (Object)(titlePartAdapter = this.adapterManager.adapterFor(titlePart)))) continue;
                String title = this.titleOf(titlePartAdapter);
                if (Strings.isNullOrEmpty((String)title)) {
                    title = titlePart.toString().trim();
                }
                if (Strings.isNullOrEmpty((String)title)) continue;
                stringBuilder.append(component.getPrepend());
                stringBuilder.append(TitleFacetViaTitleAnnotation.abbreviated(title, component.abbreviateTo));
                stringBuilder.append(component.getAppend());
            }
            return stringBuilder.toString().trim();
        }
        catch (RuntimeException ex) {
            LOG.warn("Title failure", (Throwable)ex);
            return "Failed Title";
        }
    }

    public static class TitleComponent {
        public static final Function<? super Annotations.Evaluator<Title>, ? extends TitleComponent> FROM_EVALUATORS = new Function<Annotations.Evaluator<Title>, TitleComponent>(){

            public TitleComponent apply(Annotations.Evaluator<Title> titleEvaluator) {
                return TitleComponent.of(titleEvaluator);
            }
        };
        private final String prepend;
        private final String append;
        private final Annotations.Evaluator<Title> titleEvaluator;
        private final int abbreviateTo;

        private TitleComponent(String prepend, String append, Annotations.Evaluator<Title> titleEvaluator, int abbreviateTo) {
            this.prepend = prepend;
            this.append = append;
            this.titleEvaluator = titleEvaluator;
            this.abbreviateTo = abbreviateTo;
        }

        public String getPrepend() {
            return this.prepend;
        }

        public String getAppend() {
            return this.append;
        }

        public Annotations.Evaluator<Title> getTitleEvaluator() {
            return this.titleEvaluator;
        }

        private static TitleComponent of(Annotations.Evaluator<Title> titleEvaluator) {
            Title annotation = titleEvaluator.getAnnotation();
            String prepend = annotation != null ? annotation.prepend() : " ";
            String append = annotation != null ? annotation.append() : "";
            int abbreviateTo = annotation != null ? annotation.abbreviatedTo() : Integer.MAX_VALUE;
            return new TitleComponent(prepend, append, titleEvaluator, abbreviateTo);
        }
    }
}

