/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.title.parser;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.title.TitleFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class TitleFacetUsingParser
extends FacetAbstract
implements TitleFacet {
    private final Parser parser;
    private final ServicesInjector dependencyInjector;

    public TitleFacetUsingParser(Parser parser, FacetHolder holder, ServicesInjector dependencyInjector) {
        super(TitleFacet.class, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.parser = parser;
        this.dependencyInjector = dependencyInjector;
    }

    @Override
    protected String toStringValues() {
        this.getServicesInjector().injectServicesInto(this.parser);
        return this.parser.toString();
    }

    @Override
    public String title(ObjectAdapter adapter) {
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getObject();
        if (object == null) {
            return null;
        }
        this.getServicesInjector().injectServicesInto(this.parser);
        return this.parser.displayTitleOf(object);
    }

    @Override
    public String title(ObjectAdapter contextAdapter, ObjectAdapter targetAdapter) {
        return this.title(targetAdapter);
    }

    public String title(ObjectAdapter adapter, String usingMask) {
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getObject();
        if (object == null) {
            return null;
        }
        this.getServicesInjector().injectServicesInto(this.parser);
        return this.parser.displayTitleOf(object, usingMask);
    }

    public ServicesInjector getServicesInjector() {
        return this.dependencyInjector;
    }
}

