/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.object.value.annotcfg;

import com.google.common.base.Strings;
import org.apache.isis.applib.annotation.Value;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacetAbstract;
import org.apache.isis.core.metamodel.facets.object.value.vsp.ValueSemanticsProviderUtil;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class ValueFacetAnnotation
extends ValueFacetAbstract {
    private static String semanticsProviderName(Class<?> annotatedClass, IsisConfiguration configuration) {
        Value annotation = annotatedClass.getAnnotation(Value.class);
        String semanticsProviderName = annotation.semanticsProviderName();
        if (!Strings.isNullOrEmpty((String)semanticsProviderName)) {
            return semanticsProviderName;
        }
        return ValueSemanticsProviderUtil.semanticsProviderNameFromConfiguration(annotatedClass, configuration);
    }

    private static Class<?> semanticsProviderClass(Class<?> annotatedClass) {
        Value annotation = annotatedClass.getAnnotation(Value.class);
        return annotation.semanticsProviderClass();
    }

    public ValueFacetAnnotation(Class<?> annotatedClass, FacetHolder holder, ServicesInjector context) {
        this(ValueFacetAnnotation.semanticsProviderName(annotatedClass, context.getConfigurationServiceInternal()), ValueFacetAnnotation.semanticsProviderClass(annotatedClass), holder, context);
    }

    private ValueFacetAnnotation(String candidateSemanticsProviderName, Class<?> candidateSemanticsProviderClass, FacetHolder holder, ServicesInjector context) {
        super(ValueSemanticsProviderUtil.valueSemanticsProviderOrNull(candidateSemanticsProviderClass, candidateSemanticsProviderName), ValueFacetAbstract.AddFacetsIfInvalidStrategy.DO_ADD, holder, context);
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

