/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.autocomplete.method;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacetAbstract;
import org.apache.isis.core.metamodel.facets.param.autocomplete.MinLengthUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class ActionParameterAutoCompleteFacetViaMethod
extends ActionParameterAutoCompleteFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;
    private final int minLength;

    public ActionParameterAutoCompleteFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, DeploymentCategory deploymentCategory, SpecificationLoader specificationLookup, AuthenticationSessionProvider authenticationSessionProvider, AdapterManager adapterManager) {
        super(holder, deploymentCategory, specificationLookup, authenticationSessionProvider, adapterManager);
        this.method = method;
        this.choicesType = choicesType;
        this.minLength = MinLengthUtil.determineMinLength(method);
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public Object[] autoComplete(ObjectAdapter owningAdapter, String searchArg, InteractionInitiatedBy interactionInitiatedBy) {
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter, searchArg);
        if (collectionOrArray == null) {
            return new Object[0];
        }
        ObjectAdapter collectionAdapter = this.getAdapterManager().adapterFor(collectionOrArray);
        FacetedMethodParameter facetedMethodParameter = (FacetedMethodParameter)this.getFacetHolder();
        Class<?> parameterType = facetedMethodParameter.getType();
        List<ObjectAdapter> visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy);
        ArrayList visibleObjects = Lists.newArrayList((Iterable)Iterables.transform(visibleAdapters, ObjectAdapter.Functions.getObject()));
        ObjectSpecification parameterSpec = this.getSpecification(parameterType);
        return CollectionUtils.getCollectionAsObjectArray(visibleObjects, parameterSpec, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }
}

