/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.param.defaults.fromtype;

import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.apache.isis.core.metamodel.facets.object.defaults.DefaultedFacet;
import org.apache.isis.core.metamodel.facets.param.defaults.fromtype.ActionParameterDefaultFacetDerivedFromTypeFacets;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class ActionParameterDefaultFacetDerivedFromTypeFactory
extends FacetFactoryAbstract {
    public ActionParameterDefaultFacetDerivedFromTypeFactory() {
        super(FeatureType.PARAMETERS_ONLY);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        if (((FacetedMethodParameter)processParameterContext.getFacetHolder()).getFacet(ActionDefaultsFacet.class) != null) {
            return;
        }
        Class<?>[] parameterTypes = processParameterContext.getMethod().getParameterTypes();
        DefaultedFacet[] parameterTypeDefaultedFacets = new DefaultedFacet[parameterTypes.length];
        boolean hasAtLeastOneDefault = false;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> paramType = parameterTypes[i];
            parameterTypeDefaultedFacets[i] = this.getDefaultedFacet(paramType);
            hasAtLeastOneDefault |= parameterTypeDefaultedFacets[i] != null;
        }
        if (hasAtLeastOneDefault) {
            FacetUtil.addFacet(new ActionParameterDefaultFacetDerivedFromTypeFacets(parameterTypeDefaultedFacets, (FacetHolder)processParameterContext.getFacetHolder()));
        }
    }

    private DefaultedFacet getDefaultedFacet(Class<?> paramType) {
        ObjectSpecification paramTypeSpec = this.getSpecificationLoader().loadSpecification(paramType);
        return paramTypeSpec.getFacet(DefaultedFacet.class);
    }
}

