/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.accessor;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.properties.accessor.PropertyAccessorFacetViaAccessor;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;

public class PropertyAccessorFacetViaAccessorFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"get", "is"};
    PersistenceSessionServiceInternal adapterManager;

    public PropertyAccessorFacetViaAccessorFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachPropertyAccessFacetForAccessorMethod(processMethodContext);
    }

    private void attachPropertyAccessFacetForAccessorMethod(FacetFactory.ProcessMethodContext processMethodContext) {
        Method accessorMethod = processMethodContext.getMethod();
        processMethodContext.removeMethod(accessorMethod);
        Object property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(new PropertyAccessorFacetViaAccessor(accessorMethod, (FacetHolder)property, this.getDeploymentCategory(), this.getConfiguration(), this.getSpecificationLoader(), this.getAuthenticationSessionProvider(), this.adapterManager));
    }

    @Override
    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return true;
        }
        return methodName.startsWith("is") && method.getReturnType() == Boolean.TYPE;
    }

    @Override
    public boolean isCollectionAccessor(Method method) {
        return false;
    }

    @Override
    public boolean isPropertyAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    @Override
    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        PropertyAccessorFacetViaAccessorFactory.appendMatchingMethods(methodRemover, "is", Boolean.TYPE, methodListToAppendTo);
        PropertyAccessorFacetViaAccessorFactory.appendMatchingMethods(methodRemover, "get", Object.class, methodListToAppendTo);
    }

    private static void appendMatchingMethods(MethodRemover methodRemover, String prefix, Class<?> returnType, List<Method> methodListToAppendTo) {
        methodListToAppendTo.addAll(methodRemover.removeMethods(MethodScope.OBJECT, prefix, returnType, false, 0));
    }

    @Override
    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterManager = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

