/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.choices.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.properties.choices.PropertyChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public class PropertyChoicesFacetViaMethod
extends PropertyChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final AdapterManager adapterManager;

    public PropertyChoicesFacetViaMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLoader specificationLookup, AdapterManager adapterManager) {
        super(holder, specificationLookup);
        this.method = method;
        this.choicesClass = choicesClass;
        this.adapterManager = adapterManager;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.CHOICES_OR_AUTOCOMPLETE;
    }

    @Override
    public Object[] getChoices(ObjectAdapter owningAdapter, SpecificationLoader specificationLookup, InteractionInitiatedBy interactionInitiatedBy) {
        Object options = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (options == null) {
            return null;
        }
        if (options.getClass().isArray()) {
            return ObjectExtensions.asArray(options);
        }
        ObjectSpecification specification = specificationLookup.loadSpecification(this.choicesClass);
        return CollectionUtils.getCollectionAsObjectArray(options, specification, this.getAdapterManager());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected AdapterManager getAdapterManager() {
        return this.adapterManager;
    }
}

