/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.mandatory.staticmethod;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.properties.mandatory.staticmethod.MandatoryFacetOnPropertyStaticMethod;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorForDeprecatedMethodPrefix;

@Deprecated
public class MandatoryFacetOnPropertyStaticMethodFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements MetaModelValidatorRefiner {
    private static final String[] PREFIXES = new String[]{"optional"};
    private final MetaModelValidatorForDeprecatedMethodPrefix validator = new MetaModelValidatorForDeprecatedMethodPrefix(PREFIXES[0]);

    public MandatoryFacetOnPropertyStaticMethodFactory() {
        super(FeatureType.PROPERTIES_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachMandatoryFacetIfOptionalMethodIsFound(processMethodContext);
    }

    private void attachMandatoryFacetIfOptionalMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(method.getName());
        Class<?> returnType = method.getReturnType();
        Class<?> cls = processMethodContext.getCls();
        Method optionalMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "optional" + capitalizedName, Boolean.TYPE, NO_PARAMETERS_TYPES);
        processMethodContext.removeMethod(optionalMethod);
        if (!MandatoryFacetOnPropertyStaticMethodFactory.indicatesOptional(optionalMethod)) {
            return;
        }
        if (returnType.isPrimitive()) {
            throw new MetaModelException(cls.getName() + "#" + capitalizedName + " cannot be an optional property as it is of a primitive type");
        }
        Object property = processMethodContext.getFacetHolder();
        MandatoryFacetOnPropertyStaticMethod facet = new MandatoryFacetOnPropertyStaticMethod((FacetHolder)property);
        FacetUtil.addFacet(this.validator.flagIfPresent(facet, processMethodContext));
    }

    private static boolean indicatesOptional(Method method) {
        if (method != null) {
            Boolean optionalMethodReturnValue = null;
            try {
                optionalMethodReturnValue = (Boolean)MethodExtensions.invoke(method, new Object[0]);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (optionalMethodReturnValue == null) {
                throw new MetaModelException("method " + method + " should return a boolean");
            }
            return optionalMethodReturnValue;
        }
        return false;
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        metaModelValidator.add(this.validator);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        ConfigurationServiceInternal configuration = servicesInjector.getConfigurationServiceInternal();
        this.validator.setConfiguration(configuration);
    }
}

