/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.properties.property.mandatory;

import java.lang.reflect.Method;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacetAbstract;

public abstract class MandatoryFacetForPropertyAnnotation
extends MandatoryFacetAbstract {
    public MandatoryFacetForPropertyAnnotation(FacetHolder holder, MandatoryFacetAbstract.Semantics semantics) {
        super(holder, semantics);
    }

    public static MandatoryFacet create(Property property, Method method, FacetHolder holder) {
        if (property == null) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            return new Primitive(holder);
        }
        Optionality optionality = property.optionality();
        switch (optionality) {
            case DEFAULT: {
                return null;
            }
            case MANDATORY: {
                return new Required(holder);
            }
            case OPTIONAL: {
                return new Optional(holder);
            }
        }
        return null;
    }

    public static class Optional
    extends MandatoryFacetForPropertyAnnotation {
        public Optional(FacetHolder holder) {
            super(holder, MandatoryFacetAbstract.Semantics.OPTIONAL);
        }
    }

    public static class Required
    extends MandatoryFacetForPropertyAnnotation {
        public Required(FacetHolder holder) {
            super(holder, MandatoryFacetAbstract.Semantics.REQUIRED);
        }
    }

    public static class Primitive
    extends MandatoryFacetForPropertyAnnotation {
        public Primitive(FacetHolder holder) {
            super(holder, MandatoryFacetAbstract.Semantics.REQUIRED);
        }
    }
}

